/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.eclipse.californium.scandium.dtls.cipher.CCMBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.InvalidMacException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AeadBlockCipher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AeadBlockCipher.class);
    public static final String AES_CCM = "AES/CCM";
    public static final String AES_CCM_NO_PADDING = "AES/CCM/NoPadding";

    public static final boolean isAesCcm(String transformation) {
        return AES_CCM_NO_PADDING.equalsIgnoreCase(transformation) || AES_CCM.equalsIgnoreCase(transformation);
    }

    public static final boolean isSupported(String transformation, int keyLength) {
        int maxKeyLengthBits = 0;
        try {
            maxKeyLengthBits = Cipher.getMaxAllowedKeyLength(transformation);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (maxKeyLengthBits == 0) {
            LOGGER.debug("{} is not supported!", (Object)transformation);
        } else if (maxKeyLengthBits == Integer.MAX_VALUE) {
            LOGGER.debug("{} is not restricted!", (Object)transformation);
        } else {
            LOGGER.debug("{} is restricted to {} bits.", (Object)transformation, (Object)maxKeyLengthBits);
        }
        return keyLength * 8 <= maxKeyLengthBits;
    }

    public static final byte[] decrypt(CipherSuite cipherSuite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] crypted, int cryptedOffset, int cryptedLength) throws GeneralSecurityException {
        if (AeadBlockCipher.isAesCcm(cipherSuite.getTransformation())) {
            return CCMBlockCipher.decrypt(key, nonce, additionalData, crypted, cryptedOffset, cryptedLength, cipherSuite.getMacLength());
        }
        return AeadBlockCipher.jreDecrypt(cipherSuite, key, nonce, additionalData, crypted, cryptedOffset, cryptedLength);
    }

    public static final byte[] encrypt(CipherSuite cipherSuite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] message) throws GeneralSecurityException {
        if (AeadBlockCipher.isAesCcm(cipherSuite.getTransformation())) {
            return CCMBlockCipher.encrypt(cipherSuite.getRecordIvLength(), key, nonce, additionalData, message, cipherSuite.getMacLength());
        }
        return AeadBlockCipher.jreEncrypt(cipherSuite.getRecordIvLength(), cipherSuite, key, nonce, additionalData, message);
    }

    private static final byte[] jreDecrypt(CipherSuite suite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] crypted, int cryptedOffset, int cryptedLength) throws GeneralSecurityException {
        Cipher cipher = suite.getThreadLocalCipher();
        GCMParameterSpec parameterSpec = new GCMParameterSpec(suite.getMacLength() * 8, nonce);
        cipher.init(2, (Key)key, parameterSpec);
        cipher.updateAAD(additionalData);
        try {
            return cipher.doFinal(crypted, cryptedOffset, cryptedLength);
        }
        catch (AEADBadTagException ex) {
            throw new InvalidMacException(ex.getMessage());
        }
    }

    private static final byte[] jreEncrypt(int outputOffset, CipherSuite suite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] message) throws GeneralSecurityException {
        Cipher cipher = suite.getThreadLocalCipher();
        GCMParameterSpec parameterSpec = new GCMParameterSpec(suite.getMacLength() * 8, nonce);
        cipher.init(1, (Key)key, parameterSpec);
        cipher.updateAAD(additionalData);
        int length = cipher.getOutputSize(message.length);
        byte[] result = new byte[length + outputOffset];
        cipher.doFinal(message, 0, message.length, result, outputOffset);
        return result;
    }
}

