/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.glaciertask;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import org.duracloud.glacierstorage.GlacierStorageProvider;
import org.duracloud.storage.error.StorageStateException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskRunner;

public class RestoreContentTaskRunner
implements TaskRunner {
    protected static final String RESTORE_IN_PROGRESS = "RestoreAlreadyInProgress";
    private static final String TASK_NAME = "restore-content";
    private static final int RESTORE_EXPIRATION_DAYS = 14;
    private StorageProvider glacierProvider;
    private GlacierStorageProvider unwrappedGlacierProvider;
    private AmazonS3Client s3Client;

    public RestoreContentTaskRunner(StorageProvider glacierProvider, GlacierStorageProvider unwrappedGlacierProvider, AmazonS3Client s3Client) {
        this.glacierProvider = glacierProvider;
        this.unwrappedGlacierProvider = unwrappedGlacierProvider;
        this.s3Client = s3Client;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String performTask(String taskParameters) {
        String contentId;
        String spaceId;
        block4: {
            spaceId = null;
            contentId = null;
            if (null != taskParameters && taskParameters.length() > 0) {
                int separator = taskParameters.indexOf("/");
                spaceId = taskParameters.substring(0, separator);
                contentId = taskParameters.substring(separator + 1);
            }
            if (null == spaceId || null == contentId || spaceId.equals("") || contentId.equals("")) {
                throw new RuntimeException("A path including a space ID and an content ID (separated by a '/') is required.");
            }
            try {
                this.s3Client.restoreObject(this.unwrappedGlacierProvider.getBucketName(spaceId), contentId, 14);
            }
            catch (AmazonS3Exception e) {
                if (!RESTORE_IN_PROGRESS.equals(e.getErrorCode())) break block4;
                throw new StorageStateException("Restore is already in progress for " + taskParameters, (Throwable)e);
            }
        }
        return "Request to restore content item " + contentId + " in space " + spaceId + " was successful.";
    }
}

