/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.config;

import java.text.MessageFormat;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.duracloud.common.db.jpa.JpaConfigurationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(basePackages={"org.duracloud.account.db"}, entityManagerFactoryRef="accountRepoEntityManagerFactory", transactionManagerRef="accountJpaRepoTransactionManager")
@EnableTransactionManagement
public class AccountJpaRepoConfig {
    private static final String ACCOUNT_REPO_ENTITY_MANAGER_FACTORY_BEAN = "accountRepoEntityManagerFactory";
    public static final String ACCOUNT_REPO_DATA_SOURCE_BEAN = "accountRepoDataSource";
    public static final String TRANSACTION_MANAGER_BEAN = "accountJpaRepoTransactionManager";
    public static final String ENTITY_MANAGER_FACTORY_BEAN = "accountRepoEntityManagerFactory";
    @Autowired
    private Environment env;

    @Bean(name={"accountRepoDataSource"}, destroyMethod="close")
    public BasicDataSource accountRepoDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        dataSource.setUrl(MessageFormat.format("jdbc:mysql://{0}:{1}/{2}?characterEncoding=utf8&characxterSetResults=utf8", this.env.getProperty("db.host", "localhost"), this.env.getProperty("db.port", "3306"), this.env.getProperty("db.name", "name")));
        dataSource.setUsername(this.env.getProperty("db.user", "user"));
        dataSource.setPassword(this.env.getProperty("db.pass", "pass"));
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("SELECT 1");
        return dataSource;
    }

    @Primary
    @Bean(name={"accountJpaRepoTransactionManager"})
    public PlatformTransactionManager accountRepoTransactionManager(@Qualifier(value="accountRepoEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager tm = new JpaTransactionManager(entityManagerFactory);
        tm.setJpaDialect((JpaDialect)new HibernateJpaDialect());
        return tm;
    }

    @Bean(name={"accountRepoEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean accountRepoEntityManagerFactory(@Qualifier(value="accountRepoDataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setDataSource(dataSource);
        emf.setPersistenceUnitName("account-repo-pu");
        emf.setPackagesToScan(new String[]{"org.duracloud.account.db"});
        JpaConfigurationUtil.configureEntityManagerFactory((Environment)this.env, (LocalContainerEntityManagerFactoryBean)emf);
        return emf;
    }
}

