/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.oaipmh;

import com.lyncode.xoai.serviceprovider.OAIServiceConfiguration;
import com.lyncode.xoai.serviceprovider.exceptions.ParseException;
import com.lyncode.xoai.serviceprovider.oaipmh.ElementParser;
import com.lyncode.xoai.serviceprovider.oaipmh.ErrorParser;
import com.lyncode.xoai.serviceprovider.oaipmh.GetRecordParser;
import com.lyncode.xoai.serviceprovider.oaipmh.IdentifyParser;
import com.lyncode.xoai.serviceprovider.oaipmh.ListIdentifiersParser;
import com.lyncode.xoai.serviceprovider.oaipmh.ListMetadataFormatsParser;
import com.lyncode.xoai.serviceprovider.oaipmh.ListRecordsParser;
import com.lyncode.xoai.serviceprovider.oaipmh.ListSetsParser;
import com.lyncode.xoai.serviceprovider.oaipmh.RequestParser;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.GetRecordType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.IdentifyType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.ListIdentifiersType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.ListMetadataFormatsType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.ListRecordsType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.ListSetsType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.OAIPMHerrorType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.OAIPMHtype;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.RequestType;
import com.lyncode.xoai.serviceprovider.parser.AboutItemParser;
import com.lyncode.xoai.serviceprovider.parser.AboutSetParser;
import com.lyncode.xoai.serviceprovider.parser.DescriptionParser;
import com.lyncode.xoai.serviceprovider.parser.MetadataParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLInputFactory2;

public class OAIPMHParser
extends ElementParser<OAIPMHtype> {
    private static final String NAME = "OAI-PMH";
    private static final String RESPONSE_DATE = "responseDate";
    private static XMLInputFactory factory = XMLInputFactory2.newInstance();
    private RequestParser reqParser;
    private ListRecordsParser listRecordsParser;
    private GetRecordParser getRecordParser;
    private ListIdentifiersParser listIdentifiersParser;
    private ListSetsParser listSetsParser;
    private ListMetadataFormatsParser listMetadataFormatsParser;
    private IdentifyParser identifyParser;
    private ErrorParser errorParser;

    private static void untilFirstStartElement(XMLEventReader reader) throws XMLStreamException {
        while (reader.peek() != null && !reader.peek().isStartElement() && !reader.peek().isEndDocument()) {
            reader.nextEvent();
        }
    }

    public static OAIPMHtype parse(InputStream instream, OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> oaiServiceConfiguration) throws ParseException {
        XMLEventReader stream;
        try {
            stream = factory.createXMLEventReader(instream);
            OAIPMHParser.untilFirstStartElement(stream);
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
        OAIPMHParser parser = new OAIPMHParser(oaiServiceConfiguration);
        return (OAIPMHtype)parser.parse(stream);
    }

    public static OAIPMHtype parse(File f, OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> oaiServiceConfiguration) throws FileNotFoundException, ParseException {
        try {
            XMLEventReader stream = factory.createXMLEventReader(new FileInputStream(f));
            OAIPMHParser.untilFirstStartElement(stream);
            OAIPMHParser parser = new OAIPMHParser(oaiServiceConfiguration);
            return (OAIPMHtype)parser.parse(stream);
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
    }

    public static OAIPMHtype parse(String filepath, OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> oaiServiceConfiguration) throws FileNotFoundException, XMLStreamException, ParseException {
        try {
            XMLEventReader stream = factory.createXMLEventReader(new FileInputStream(filepath));
            OAIPMHParser.untilFirstStartElement(stream);
            OAIPMHParser parser = new OAIPMHParser(oaiServiceConfiguration);
            return (OAIPMHtype)parser.parse(stream);
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
    }

    public OAIPMHParser(OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> oaiServiceConfiguration) {
        super(oaiServiceConfiguration);
        this.reqParser = new RequestParser(oaiServiceConfiguration);
        this.listRecordsParser = new ListRecordsParser(oaiServiceConfiguration);
        this.getRecordParser = new GetRecordParser(oaiServiceConfiguration);
        this.listIdentifiersParser = new ListIdentifiersParser(oaiServiceConfiguration);
        this.listSetsParser = new ListSetsParser(oaiServiceConfiguration);
        this.listMetadataFormatsParser = new ListMetadataFormatsParser(oaiServiceConfiguration);
        this.identifyParser = new IdentifyParser(oaiServiceConfiguration);
        this.errorParser = new ErrorParser(oaiServiceConfiguration);
    }

    @Override
    protected OAIPMHtype parseElement(XMLEventReader reader) throws ParseException {
        OAIPMHtype pmh = new OAIPMHtype();
        try {
            if (!reader.peek().asStartElement().getName().getLocalPart().equals(NAME)) {
                throw new ParseException("Expecting OAI-PMH element");
            }
            reader.nextEvent();
            this.nextElement(reader);
            pmh.setResponseDate(super.getConfiguration().getFormatter().parse(this.getElement(reader, RESPONSE_DATE)));
            pmh.setRequest((RequestType)this.reqParser.parse(reader));
            String name = reader.peek().asStartElement().getName().getLocalPart();
            if (name.equals("ListRecords")) {
                pmh.setListRecords((ListRecordsType)this.listRecordsParser.parse(reader));
            } else if (name.equals("GetRecord")) {
                pmh.setGetRecord((GetRecordType)this.getRecordParser.parse(reader));
            } else if (name.equals("ListIdentifiers")) {
                pmh.setListIdentifiers((ListIdentifiersType)this.listIdentifiersParser.parse(reader));
            } else if (name.equals("ListSets")) {
                pmh.setListSets((ListSetsType)this.listSetsParser.parse(reader));
            } else if (name.equals("ListMetadataFormats")) {
                pmh.setListMetadataFormats((ListMetadataFormatsType)this.listMetadataFormatsParser.parse(reader));
            } else if (name.equals("Identify")) {
                pmh.setIdentify((IdentifyType)this.identifyParser.parse(reader));
            } else {
                while (reader.peek().asStartElement().getName().getLocalPart().equals("error")) {
                    pmh.getError().add((OAIPMHerrorType)this.errorParser.parse(reader));
                }
            }
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e);
        }
        return pmh;
    }
}

