/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoaiconfig;

import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XMLWritable;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.read.XmlReader;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.ConditionConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.ContextConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.FilterConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.FormatConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.SetConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.TransformerConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.ConfigurationParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class Configuration
implements XMLWritable {
    private List<ContextConfiguration> contextConfigurations = new ArrayList<ContextConfiguration>();
    private List<FormatConfiguration> formatConfigurations = new ArrayList<FormatConfiguration>();
    private List<TransformerConfiguration> transformerConfigurations = new ArrayList<TransformerConfiguration>();
    private List<FilterConfiguration> filters = new ArrayList<FilterConfiguration>();
    private List<ConditionConfiguration> conditions = new ArrayList<ConditionConfiguration>();
    private List<SetConfiguration> sets = new ArrayList<SetConfiguration>();
    private int maxListRecordsSize = 100;
    private int maxListSetsSize = 100;
    private int maxListIdentifiersSize = 100;
    private boolean indented = false;
    private String stylesheet;
    private String descriptionFile;

    public static Configuration readConfiguration(InputStream input) throws ConfigurationException {
        try {
            return new ConfigurationParser().parse(new XmlReader(input));
        }
        catch (XMLStreamException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public Integer getMaxListRecordsSize() {
        return this.maxListRecordsSize;
    }

    public Configuration withMaxListRecordsSize(int maxListRecordsSize) {
        this.maxListRecordsSize = maxListRecordsSize;
        return this;
    }

    public Integer getMaxListSetsSize() {
        return this.maxListSetsSize;
    }

    public Configuration withMaxListSetsSize(int maxListSetsSize) {
        this.maxListSetsSize = maxListSetsSize;
        return this;
    }

    public Integer getMaxListIdentifiersSize() {
        return this.maxListIdentifiersSize;
    }

    public Configuration withMaxListIdentifiersSize(int maxListIdentifiersSize) {
        this.maxListIdentifiersSize = maxListIdentifiersSize;
        return this;
    }

    public Boolean getIndented() {
        return this.indented;
    }

    public Configuration withIndented(Boolean indented) {
        this.indented = indented;
        return this;
    }

    public String getStylesheet() {
        return this.stylesheet;
    }

    public Configuration withStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
        return this;
    }

    public String getDescriptionFile() {
        return this.descriptionFile;
    }

    public Configuration withDescriptionFile(String descriptionFile) {
        this.descriptionFile = descriptionFile;
        return this;
    }

    public List<ContextConfiguration> getContexts() {
        return this.contextConfigurations;
    }

    public Configuration withContextConfigurations(Collection<ContextConfiguration> contextConfigurations) {
        this.contextConfigurations.addAll(contextConfigurations);
        return this;
    }

    public Configuration withContextConfigurations(ContextConfiguration ... contextConfigurations) {
        this.contextConfigurations.addAll(Arrays.asList(contextConfigurations));
        return this;
    }

    public List<FormatConfiguration> getFormats() {
        return this.formatConfigurations;
    }

    public Configuration withFormatConfigurations(Collection<FormatConfiguration> formatConfigurations) {
        this.formatConfigurations.addAll(formatConfigurations);
        return this;
    }

    public Configuration withFormatConfigurations(FormatConfiguration ... formatConfigurations) {
        this.formatConfigurations.addAll(Arrays.asList(formatConfigurations));
        return this;
    }

    public List<TransformerConfiguration> getTransformers() {
        return this.transformerConfigurations;
    }

    public Configuration withTransformerConfigurations(Collection<TransformerConfiguration> transformerConfigurations) {
        this.transformerConfigurations.addAll(transformerConfigurations);
        return this;
    }

    public Configuration withTransformerConfigurations(TransformerConfiguration ... transformerConfigurations) {
        this.transformerConfigurations.addAll(Arrays.asList(transformerConfigurations));
        return this;
    }

    public List<FilterConfiguration> getFilters() {
        return this.filters;
    }

    public Configuration withFilters(List<FilterConfiguration> filters) {
        this.filters.addAll(filters);
        return this;
    }

    public Configuration withFilters(FilterConfiguration ... filters) {
        this.filters.addAll(Arrays.asList(filters));
        return this;
    }

    public List<ConditionConfiguration> getConditions() {
        return this.conditions;
    }

    public Configuration withConditions(List<ConditionConfiguration> conditions) {
        this.conditions.addAll(conditions);
        return this;
    }

    public Configuration withConditions(ConditionConfiguration ... conditions) {
        this.conditions.addAll(Arrays.asList(conditions));
        return this;
    }

    public List<SetConfiguration> getSets() {
        return this.sets;
    }

    public Configuration withSets(List<SetConfiguration> sets) {
        this.sets.addAll(sets);
        return this;
    }

    public Configuration withSets(SetConfiguration ... sets) {
        this.sets.addAll(Arrays.asList(sets));
        return this;
    }

    @Override
    public void write(XmlOutputContext writer) throws WritingXmlException {
        if (!this.hasContexts()) {
            throw new WritingXmlException("Configuration must have at least one Context");
        }
        if (!this.hasFormats()) {
            throw new WritingXmlException("Configuration must have at least one Format");
        }
        try {
            writer.getWriter().writeStartElement("Configuration");
            writer.getWriter().writeNamespace("", "http://www.lyncode.com/XOAIConfiguration");
            writer.getWriter().writeAttribute("maxListRecordsSize", String.valueOf(this.maxListRecordsSize));
            writer.getWriter().writeAttribute("maxListSetsSize", String.valueOf(this.maxListRecordsSize));
            writer.getWriter().writeAttribute("maxListIdentifiersSize", String.valueOf(this.maxListRecordsSize));
            writer.getWriter().writeAttribute("indented", String.valueOf(this.indented));
            if (this.hasStylesheet()) {
                writer.getWriter().writeAttribute("stylesheet", this.stylesheet);
            }
            if (this.hasDescriptionFile()) {
                writer.getWriter().writeAttribute("descriptionFile", this.descriptionFile);
            }
            writer.getWriter().writeStartElement("Contexts");
            for (ContextConfiguration context : this.contextConfigurations) {
                context.write(writer);
            }
            writer.getWriter().writeEndElement();
            writer.getWriter().writeStartElement("Formats");
            for (FormatConfiguration formatConfiguration : this.formatConfigurations) {
                formatConfiguration.write(writer);
            }
            writer.getWriter().writeEndElement();
            if (this.hasTransformers()) {
                writer.getWriter().writeStartElement("Transformers");
                for (TransformerConfiguration transformerConfiguration : this.transformerConfigurations) {
                    transformerConfiguration.write(writer);
                }
                writer.getWriter().writeEndElement();
            }
            if (this.hasFilters()) {
                writer.getWriter().writeStartElement("Filters");
                for (FilterConfiguration filterConfiguration : this.filters) {
                    filterConfiguration.write(writer);
                }
                for (ConditionConfiguration conditionConfiguration : this.conditions) {
                    conditionConfiguration.write(writer);
                }
                writer.getWriter().writeEndElement();
            }
            if (this.hasSets()) {
                writer.getWriter().writeStartElement("Sets");
                for (SetConfiguration setConfiguration : this.sets) {
                    setConfiguration.write(writer);
                }
                writer.getWriter().writeEndElement();
            }
            writer.getWriter().writeEndElement();
            writer.getWriter().close();
        }
        catch (XMLStreamException e) {
            throw new WritingXmlException(e);
        }
    }

    public boolean hasSets() {
        return this.sets != null && !this.sets.isEmpty();
    }

    public boolean hasFilters() {
        return this.hasFilterDefinitions() || this.hasConditionDefinitions();
    }

    public boolean hasConditionDefinitions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasFilterDefinitions() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public boolean hasTransformers() {
        return this.transformerConfigurations != null && !this.transformerConfigurations.isEmpty();
    }

    public boolean hasDescriptionFile() {
        return this.descriptionFile != null;
    }

    public boolean hasStylesheet() {
        return this.stylesheet != null;
    }

    public boolean hasFormats() {
        return this.formatConfigurations != null && !this.formatConfigurations.isEmpty();
    }

    public boolean hasContexts() {
        return this.contextConfigurations != null && !this.contextConfigurations.isEmpty();
    }

    public void write(ByteArrayOutputStream output) throws XMLStreamException, WritingXmlException {
        this.write(XmlOutputContext.emptyContext(output));
    }
}

