/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoai;

import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XMLWritable;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.util.XmlIOUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.stream.XMLStreamException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Element", propOrder={"field", "element"})
public class Element
implements XMLWritable {
    protected List<Field> field;
    protected List<Element> element;
    @XmlAttribute(required=true)
    protected String name;

    public List<Field> getField() {
        if (this.field == null) {
            this.field = new ArrayList<Field>();
        }
        return this.field;
    }

    public List<Element> getElement() {
        if (this.element == null) {
            this.element = new ArrayList<Element>();
        }
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public void write(XmlOutputContext context) throws WritingXmlException {
        try {
            if (this.name != null) {
                context.getWriter().writeAttribute("name", this.getName());
            }
            for (Field f : this.getField()) {
                XmlIOUtils.writeElement(context, "field", f);
            }
            for (Element e : this.getElement()) {
                XmlIOUtils.writeElement(context, "element", e);
            }
        }
        catch (XMLStreamException e) {
            throw new WritingXmlException(e);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"value"})
    public static class Field
    implements XMLWritable {
        @XmlValue
        protected String value;
        @XmlAttribute
        protected String name;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        @Override
        public void write(XmlOutputContext writer) throws WritingXmlException {
            try {
                if (this.name != null) {
                    writer.getWriter().writeAttribute("name", this.getName());
                }
                if (this.value != null) {
                    writer.getWriter().writeCharacters(this.value);
                }
            }
            catch (XMLStreamException e) {
                throw new WritingXmlException(e);
            }
        }
    }
}

