/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.oaipmh;

import com.lyncode.xoai.dataprovider.core.XOAIManager;
import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XMLWritable;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.oaipmh.OAIPMHtype;
import javax.xml.stream.XMLStreamException;

public class OAIPMH
implements XMLWritable {
    public static final String NAMESPACE_URI = "http://www.openarchives.org/OAI/2.0/";
    public static final String SCHEMA_LOCATION = "http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd";
    private final XOAIManager manager;
    private OAIPMHtype info;

    public OAIPMH(XOAIManager manager) {
        this.manager = manager;
    }

    public OAIPMHtype getInfo() {
        return this.info;
    }

    public void setInfo(OAIPMHtype info) {
        this.info = info;
    }

    @Override
    public void write(XmlOutputContext context) throws WritingXmlException {
        try {
            if (this.manager.hasStyleSheet()) {
                context.getWriter().writeProcessingInstruction("xml-stylesheet href='" + this.manager.getStyleSheet() + "' type='text/xsl'");
            }
            context.getWriter().writeStartElement("OAI-PMH");
            context.getWriter().writeDefaultNamespace(NAMESPACE_URI);
            context.getWriter().writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            context.getWriter().writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd");
            if (this.info != null) {
                this.info.write(context);
            }
            context.getWriter().writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WritingXmlException(e);
        }
    }
}

