/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.handlers;

import com.lyncode.xoai.dataprovider.core.ListItemsResults;
import com.lyncode.xoai.dataprovider.core.OAIParameters;
import com.lyncode.xoai.dataprovider.core.ReferenceSet;
import com.lyncode.xoai.dataprovider.core.ResumptionToken;
import com.lyncode.xoai.dataprovider.core.XOAIContext;
import com.lyncode.xoai.dataprovider.data.About;
import com.lyncode.xoai.dataprovider.data.Item;
import com.lyncode.xoai.dataprovider.data.internal.ItemHelper;
import com.lyncode.xoai.dataprovider.data.internal.ItemRepositoryHelper;
import com.lyncode.xoai.dataprovider.data.internal.MetadataFormat;
import com.lyncode.xoai.dataprovider.data.internal.SetRepositoryHelper;
import com.lyncode.xoai.dataprovider.exceptions.BadArgumentException;
import com.lyncode.xoai.dataprovider.exceptions.CannotDisseminateFormatException;
import com.lyncode.xoai.dataprovider.exceptions.CannotDisseminateRecordException;
import com.lyncode.xoai.dataprovider.exceptions.DoesNotSupportSetsException;
import com.lyncode.xoai.dataprovider.exceptions.HandlerException;
import com.lyncode.xoai.dataprovider.exceptions.NoMatchesException;
import com.lyncode.xoai.dataprovider.exceptions.NoMetadataFormatsException;
import com.lyncode.xoai.dataprovider.exceptions.OAIException;
import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.handlers.VerbHandler;
import com.lyncode.xoai.dataprovider.services.api.DateProvider;
import com.lyncode.xoai.dataprovider.services.api.RepositoryConfiguration;
import com.lyncode.xoai.dataprovider.services.api.ResumptionTokenFormatter;
import com.lyncode.xoai.dataprovider.xml.oaipmh.AboutType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.HeaderType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.ListRecordsType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.MetadataType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.RecordType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.ResumptionTokenType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.StatusType;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListRecordsHandler
extends VerbHandler<ListRecordsType> {
    private static Logger log = LogManager.getLogger(ListRecordsHandler.class);
    private final int maxListSize;
    private SetRepositoryHelper setRepository;
    private ItemRepositoryHelper itemRepositoryHelper;
    private RepositoryConfiguration identify;
    private XOAIContext context;
    private ResumptionTokenFormatter resumptionFormat;

    public ListRecordsHandler(DateProvider formatter, int maxListSize, SetRepositoryHelper setRepository, ItemRepositoryHelper itemRepositoryHelper, RepositoryConfiguration identify, XOAIContext context, ResumptionTokenFormatter format) {
        super(formatter);
        this.maxListSize = maxListSize;
        this.setRepository = setRepository;
        this.itemRepositoryHelper = itemRepositoryHelper;
        this.identify = identify;
        this.context = context;
        this.resumptionFormat = format;
    }

    @Override
    public ListRecordsType handle(OAIParameters parameters) throws OAIException, HandlerException {
        ListItemsResults result;
        ListRecordsType res = new ListRecordsType();
        ResumptionToken token = parameters.getResumptionToken();
        int length = this.maxListSize;
        if (parameters.hasSet() && !this.setRepository.supportSets()) {
            throw new DoesNotSupportSetsException();
        }
        log.debug("Getting items from data source");
        if (!parameters.hasSet()) {
            result = parameters.hasFrom() && !parameters.hasUntil() ? this.itemRepositoryHelper.getItems(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getFrom()) : (!parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemsUntil(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getUntil()) : (parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItems(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getFrom(), parameters.getUntil()) : this.itemRepositoryHelper.getItems(this.context, token.getOffset(), length, parameters.getMetadataPrefix())));
        } else {
            if (!this.setRepository.exists(this.context, parameters.getSet())) {
                throw new NoMatchesException();
            }
            result = parameters.hasFrom() && !parameters.hasUntil() ? this.itemRepositoryHelper.getItems(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getFrom()) : (!parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemsUntil(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getUntil()) : (parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItems(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getFrom(), parameters.getUntil()) : this.itemRepositoryHelper.getItems(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getSet())));
        }
        log.debug("Items retrived from data source");
        List<Item> results = result.getResults();
        if (results.isEmpty()) {
            throw new NoMatchesException();
        }
        ResumptionToken newToken = result.hasMore() ? new ResumptionToken(token.getOffset() + length, parameters) : new ResumptionToken();
        if (parameters.hasResumptionToken() || !newToken.isEmpty()) {
            ResumptionTokenType resToken = new ResumptionTokenType();
            if (!newToken.isEmpty()) {
                resToken.setValue(this.resumptionFormat.format(newToken));
            }
            resToken.setCursor(token.getOffset() / this.maxListSize);
            if (result.hasTotalResults()) {
                resToken.setCompleteListSize(result.getTotal());
            }
            res.setResumptionToken(resToken);
        }
        log.debug("Now adding records to the OAI-PMH Output");
        for (Item i : results) {
            res.getRecord().add(this.createRecord(parameters, i));
        }
        return res;
    }

    private RecordType createRecord(OAIParameters parameters, Item item) throws BadArgumentException, CannotDisseminateRecordException, OAIException, NoMetadataFormatsException, CannotDisseminateFormatException {
        log.debug("Metadata format: " + parameters.getMetadataPrefix());
        MetadataFormat format = this.context.getFormatByPrefix(parameters.getMetadataPrefix());
        RecordType record = new RecordType();
        HeaderType header = new HeaderType();
        log.debug("ItemHelper: " + item.getIdentifier());
        header.setIdentifier(item.getIdentifier());
        ItemHelper itemHelperWrap = new ItemHelper(item);
        header.setDatestamp(this.getFormatter().format(item.getDatestamp(), this.identify.getGranularity()));
        for (ReferenceSet s : itemHelperWrap.getSets(this.context)) {
            header.getSetSpec().add(s.getSetSpec());
        }
        if (item.isDeleted()) {
            header.setStatus(StatusType.DELETED);
        }
        record.setHeader(header);
        if (!item.isDeleted()) {
            MetadataType metadata = null;
            try {
                metadata = this.context.getTransformer().hasXslTemplates() ? new MetadataType(itemHelperWrap.toPipeline(true).apply((Templates)this.context.getTransformer().getXslTemplates().getValue()).apply(format.getXsltTemplates()).getTransformed()) : new MetadataType(itemHelperWrap.toPipeline(true).apply(format.getXsltTemplates()).getTransformed());
            }
            catch (WritingXmlException e) {
                throw new OAIException(e);
            }
            catch (XMLStreamException e) {
                throw new OAIException(e);
            }
            catch (TransformerException e) {
                throw new OAIException(e);
            }
            catch (IOException e) {
                throw new OAIException(e);
            }
            record.setMetadata(metadata);
            log.debug("Outputting About");
            if (item.getAbout() != null) {
                for (About abj : item.getAbout()) {
                    AboutType about = new AboutType();
                    about.setAny(abj.getXML());
                    record.getAbout().add(about);
                }
            }
        }
        return record;
    }
}

