/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.format;

import com.lyncode.xoai.dataprovider.data.ItemIdentifier;
import com.lyncode.xoai.dataprovider.data.internal.MetadataFormat;
import com.lyncode.xoai.dataprovider.exceptions.BadArgumentException;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.filter.FilterManager;
import com.lyncode.xoai.dataprovider.services.api.ResourceResolver;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.FormatConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataFormatManager {
    private static Logger log = LogManager.getLogger(MetadataFormatManager.class);
    private Map<String, MetadataFormat> contexts = new HashMap<String, MetadataFormat>();

    public MetadataFormatManager(ResourceResolver resolver, List<FormatConfiguration> config, FilterManager filterManager) throws ConfigurationException {
        for (FormatConfiguration format : config) {
            Templates templates = null;
            try {
                templates = resolver.getTemplates(format.getXslt());
            }
            catch (TransformerConfigurationException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            MetadataFormat metadataFormat = new MetadataFormat(format.getPrefix(), templates, format.getNamespace(), format.getSchemaLocation());
            if (format.hasFilter()) {
                metadataFormat.setFilter(filterManager.getFilter(format.getFilter().getReference()));
            }
            this.contexts.put(format.getId(), metadataFormat);
        }
    }

    public boolean formatExists(String id) {
        return this.contexts.containsKey(id);
    }

    public MetadataFormat getFormat(String id) {
        return this.contexts.get(id);
    }

    public List<MetadataFormat> getFormats(ItemIdentifier item) {
        ArrayList<MetadataFormat> formats = new ArrayList<MetadataFormat>();
        for (MetadataFormat format : this.contexts.values()) {
            if (!format.isApplicable(item)) continue;
            formats.add(format);
        }
        return formats;
    }

    public MetadataFormat getFormatByPrefix(String prefix) throws BadArgumentException {
        for (MetadataFormat f : this.contexts.values()) {
            if (!f.getPrefix().equals(prefix)) continue;
            return f;
        }
        throw new BadArgumentException("There is no metadata schema with the given metadataPrefix");
    }
}

