/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.filter;

import com.lyncode.xoai.dataprovider.data.Filter;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.filter.conditions.AndCondition;
import com.lyncode.xoai.dataprovider.filter.conditions.Condition;
import com.lyncode.xoai.dataprovider.filter.conditions.CustomCondition;
import com.lyncode.xoai.dataprovider.filter.conditions.NotCondition;
import com.lyncode.xoai.dataprovider.filter.conditions.OrCondition;
import com.lyncode.xoai.dataprovider.services.api.FilterResolver;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.ConditionConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.FilterConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.conditions.AndConditionConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.conditions.CustomConditionConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.conditions.FilterConditionConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.conditions.NotConditionConfiguration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.conditions.OrConditionConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterManager {
    private Map<String, Condition> combinedFilters;
    private Map<String, CustomCondition> customConditions = new HashMap<String, CustomCondition>();

    public FilterManager(FilterResolver resolver, List<FilterConfiguration> filters, List<ConditionConfiguration> conditions) throws ConfigurationException {
        for (ConditionConfiguration conditionConfiguration : conditions) {
            try {
                Class<?> filterClass = Class.forName(conditionConfiguration.getClazz());
                if (!Filter.class.isAssignableFrom(filterClass)) {
                    throw new ConfigurationException("Class " + conditionConfiguration.getClazz() + " does not implements Filter");
                }
                this.customConditions.put(conditionConfiguration.getId(), new CustomCondition(resolver, filterClass, conditionConfiguration.getConfiguration()));
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException(ex.getMessage(), ex);
            }
        }
        this.combinedFilters = new HashMap<String, Condition>();
        for (FilterConfiguration combinedFilter : filters) {
            this.combinedFilters.put(combinedFilter.getId(), this.getDefinition(resolver, combinedFilter.getDefinition()));
        }
    }

    private Condition getDefinition(FilterResolver resolver, FilterConditionConfiguration filterCondition) {
        if (filterCondition.is(AndConditionConfiguration.class)) {
            return new AndCondition(resolver, this.getDefinition(resolver, ((AndConditionConfiguration)filterCondition).getLeft()), this.getDefinition(resolver, ((AndConditionConfiguration)filterCondition).getRight()));
        }
        if (filterCondition.is(OrConditionConfiguration.class)) {
            return new OrCondition(resolver, this.getDefinition(resolver, ((OrConditionConfiguration)filterCondition).getLeft()), this.getDefinition(resolver, ((OrConditionConfiguration)filterCondition).getRight()));
        }
        if (filterCondition.is(NotConditionConfiguration.class)) {
            return new NotCondition(resolver, this.getDefinition(resolver, ((NotConditionConfiguration)filterCondition).getCondition()));
        }
        return this.customConditions.get(((CustomConditionConfiguration)filterCondition).getFilter().getReference());
    }

    public boolean filterExists(String id) {
        return this.combinedFilters.containsKey(id) || this.customConditions.containsKey(id);
    }

    public Condition getFilter(String id) {
        if (this.combinedFilters.containsKey(id)) {
            return this.combinedFilters.get(id);
        }
        return this.customConditions.get(id);
    }
}

