/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.data.internal;

import com.lyncode.xoai.dataprovider.data.Item;
import com.lyncode.xoai.dataprovider.data.internal.ItemIdentifyHelper;
import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.util.XSLPipeline;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLOutputFactory2;

public class ItemHelper
extends ItemIdentifyHelper {
    private static XMLOutputFactory outputFactory = XMLOutputFactory2.newFactory();
    private Item item;

    public ItemHelper(Item item) {
        super(item);
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    public InputStream toStream() throws XMLStreamException, WritingXmlException {
        if (this.item.getMetadata().isCompiled()) {
            return new ByteArrayInputStream(this.item.getMetadata().getCompiled().getBytes());
        }
        ByteArrayOutputStream mdOUT = new ByteArrayOutputStream();
        XmlOutputContext context = XmlOutputContext.emptyContext(mdOUT);
        this.item.getMetadata().getMetadata().write(context);
        context.getWriter().flush();
        context.getWriter().close();
        return new ByteArrayInputStream(mdOUT.toByteArray());
    }

    public XSLPipeline toPipeline(boolean omitXMLDeclaration) throws WritingXmlException, XMLStreamException {
        return new XSLPipeline(this.toStream(), omitXMLDeclaration);
    }
}

