/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.core;

import com.lyncode.xoai.dataprovider.data.Item;
import com.lyncode.xoai.dataprovider.data.ItemIdentifier;
import com.lyncode.xoai.dataprovider.data.internal.MetadataFormat;
import com.lyncode.xoai.dataprovider.data.internal.MetadataTransformer;
import com.lyncode.xoai.dataprovider.exceptions.CannotDisseminateFormatException;
import com.lyncode.xoai.dataprovider.filter.conditions.Condition;
import com.lyncode.xoai.dataprovider.sets.StaticSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XOAIContext {
    private static Logger log = LogManager.getLogger(XOAIContext.class);
    private String baseUrl;
    private String name;
    private String description;
    private Condition condition;
    private Map<String, StaticSet> sets;
    private MetadataTransformer transformer;
    private Map<String, MetadataFormat> formats;
    private List<StaticSet> cachedSets = null;

    public XOAIContext(String baseUrl, String name, String description, MetadataTransformer transformer, List<MetadataFormat> formats, List<StaticSet> sets) {
        this.baseUrl = baseUrl;
        this.name = name;
        this.description = description;
        this.transformer = transformer;
        this.formats = new HashMap<String, MetadataFormat>();
        for (MetadataFormat mdf : formats) {
            this.formats.put(mdf.getPrefix(), mdf);
        }
        this.sets = new HashMap<String, StaticSet>();
        for (StaticSet s : sets) {
            this.sets.put(s.getSetSpec(), s);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public MetadataTransformer getTransformer() {
        return this.transformer;
    }

    public List<StaticSet> getStaticSets() {
        if (this.cachedSets == null) {
            log.debug("{ XOAI } Static Sets for this ContextConfiguration: " + this.sets.values().size());
            this.cachedSets = new ArrayList<StaticSet>(this.sets.values());
        }
        return this.cachedSets;
    }

    public Condition getSetFilter(String setID) {
        log.debug("{ XOAI } Getting StaticSet filters");
        return this.sets.get(setID).getCondition();
    }

    public MetadataFormat getFormatByPrefix(String prefix) throws CannotDisseminateFormatException {
        for (MetadataFormat format : this.formats.values()) {
            if (!format.getPrefix().equals(prefix)) continue;
            return format;
        }
        throw new CannotDisseminateFormatException(prefix);
    }

    public List<MetadataFormat> getFormats() {
        return new ArrayList<MetadataFormat>(this.formats.values());
    }

    public List<MetadataFormat> getFormats(Item item) {
        ArrayList<MetadataFormat> formats = new ArrayList<MetadataFormat>();
        if (this.isItemShown(item)) {
            for (MetadataFormat format : this.formats.values()) {
                if (!item.isDeleted() && !format.isApplicable(item)) continue;
                formats.add(format);
            }
        }
        return formats;
    }

    public boolean isItemShown(ItemIdentifier item) {
        if (this.hasCondition()) {
            return this.condition.getFilter().isItemShown(item);
        }
        return true;
    }

    public boolean isStaticSet(String setSpec) {
        for (StaticSet s : this.getStaticSets()) {
            if (!s.getSetSpec().equals(setSpec)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        if (this.name == null) {
            return this.baseUrl;
        }
        return this.name;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }
}

