/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.builders.dataprovider;

import com.lyncode.builder.Builder;
import com.lyncode.xoai.builders.dataprovider.MetadataElementFieldBuilder;
import com.lyncode.xoai.dataprovider.xml.xoai.Element;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ElementBuilder
implements Builder<Element> {
    private String name;
    private Collection<Element> subElements = new ArrayList<Element>();
    private Collection<Element.Field> fields = new ArrayList<Element.Field>();

    public ElementBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public ElementBuilder withSubElements(Element ... subElements) {
        this.subElements.addAll(Arrays.asList(subElements));
        return this;
    }

    public ElementBuilder withFields(Element.Field ... fields) {
        this.fields.addAll(Arrays.asList(fields));
        return this;
    }

    public ElementBuilder withField(String name, String value) {
        this.fields.add(new MetadataElementFieldBuilder().withName(name).withValue(value).build());
        return this;
    }

    @Override
    public Element build() {
        Element element = new Element();
        element.setName(this.name);
        element.getElement().addAll(this.subElements);
        element.getField().addAll(this.fields);
        return element;
    }
}

