/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.builder;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.lyncode.builder.Builder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListBuilder<T>
implements Builder<List<T>> {
    private List<T> list = new ArrayList<T>();

    public ListBuilder<T> add(Collection<T> list) {
        this.list.addAll(list);
        return this;
    }

    public ListBuilder<T> add(T ... list) {
        for (T t : list) {
            this.list.add(t);
        }
        return this;
    }

    @Override
    public List<T> build() {
        return this.list;
    }

    public <E> List<E> build(Function<T, E> transformer) {
        return Lists.newArrayList((Iterable)Collections2.transform(this.list, transformer));
    }
}

