/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.builder;

import com.lyncode.builder.Builder;
import java.util.Calendar;
import java.util.Date;

public class DateBuilder
implements Builder<Date> {
    public static final int MIN_MILLISECONDS = 0;
    public static final int MAX_MILLISECONDS = 999;
    private Calendar calendar = Calendar.getInstance();

    public DateBuilder() {
    }

    public DateBuilder(Date time) {
        this.calendar.setTime(time);
    }

    public DateBuilder addDays(int days) {
        this.calendar.add(6, days);
        return this;
    }

    public DateBuilder subtractDays(int days) {
        this.calendar.add(6, days * -1);
        return this;
    }

    public DateBuilder setMilliseconds(int milliseconds) {
        this.calendar.set(14, milliseconds);
        return this;
    }

    public DateBuilder setMinMilliseconds() {
        this.calendar.set(14, 0);
        return this;
    }

    public DateBuilder setMaxMilliseconds() {
        this.calendar.set(14, 999);
        return this;
    }

    @Override
    public Date build() {
        return this.calendar.getTime();
    }
}

