/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.oaipmh;

import com.lyncode.xoai.serviceprovider.OAIServiceConfiguration;
import com.lyncode.xoai.serviceprovider.exceptions.ParseException;
import com.lyncode.xoai.serviceprovider.oaipmh.AboutTypeParser;
import com.lyncode.xoai.serviceprovider.oaipmh.ElementParser;
import com.lyncode.xoai.serviceprovider.oaipmh.HeaderParser;
import com.lyncode.xoai.serviceprovider.oaipmh.MetadataTypeParser;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.AboutType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.HeaderType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.MetadataType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.RecordType;
import com.lyncode.xoai.serviceprovider.parser.AboutItemParser;
import com.lyncode.xoai.serviceprovider.parser.AboutSetParser;
import com.lyncode.xoai.serviceprovider.parser.DescriptionParser;
import com.lyncode.xoai.serviceprovider.parser.MetadataParser;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;

public class RecordParser
extends ElementParser<RecordType> {
    public static final String NAME = "record";
    private HeaderParser headerParser;
    private MetadataTypeParser metadataParser;
    private AboutTypeParser aboutParser;

    public RecordParser(OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> oaiServiceConfiguration) {
        super(oaiServiceConfiguration);
        this.headerParser = new HeaderParser(oaiServiceConfiguration);
        this.metadataParser = new MetadataTypeParser(oaiServiceConfiguration);
        this.aboutParser = new AboutTypeParser(oaiServiceConfiguration);
    }

    @Override
    protected RecordType parseElement(XMLEventReader reader) throws ParseException {
        RecordType record = new RecordType();
        try {
            if (!reader.peek().asStartElement().getName().getLocalPart().equals(NAME)) {
                throw new ParseException("Expecting record element");
            }
            reader.nextEvent();
            this.nextElement(reader);
            record.setHeader((HeaderType)this.headerParser.parse(reader));
            record.setMetadata((MetadataType)this.metadataParser.parse(reader));
            while (reader.peek().isStartElement()) {
                record.getAbout().add((AboutType)this.aboutParser.parse(reader));
            }
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
        return record;
    }
}

