/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.iterators;

import com.lyncode.xoai.serviceprovider.OAIServiceConfiguration;
import com.lyncode.xoai.serviceprovider.core.Parameters;
import com.lyncode.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import com.lyncode.xoai.serviceprovider.exceptions.InternalHarvestException;
import com.lyncode.xoai.serviceprovider.exceptions.NoMetadataFormatsException;
import com.lyncode.xoai.serviceprovider.exceptions.ParseException;
import com.lyncode.xoai.serviceprovider.oaipmh.OAIPMHParser;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.ListMetadataFormatsType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.MetadataFormatType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.OAIPMHtype;
import com.lyncode.xoai.serviceprovider.parser.AboutItemParser;
import com.lyncode.xoai.serviceprovider.parser.AboutSetParser;
import com.lyncode.xoai.serviceprovider.parser.DescriptionParser;
import com.lyncode.xoai.serviceprovider.parser.MetadataParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class MetadataFormatIterator {
    private Parameters parameters;
    private OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> config;
    private Queue<MetadataFormatType> _queue = null;

    public MetadataFormatIterator(OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> config, Parameters parameters) {
        this.config = config;
        this.parameters = parameters;
    }

    private String makeUrl() {
        return this.parameters.toUrl();
    }

    public ListMetadataFormatsType harvest() throws InternalHarvestException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        String url = this.makeUrl();
        this.config.getLogger().info((Object)("Harvesting: " + url));
        HttpGet httpget = new HttpGet(url);
        httpget.addHeader("User-Agent", this.config.getServiceName() + " : XOAI Service Provider");
        httpget.addHeader("From", this.config.getServiceName());
        HttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpget);
            StatusLine status = response.getStatusLine();
            this.config.getLogger().debug((Object)response.getStatusLine());
            if (status.getStatusCode() == 503) {
                Header[] headers;
                for (Header h : headers = response.getAllHeaders()) {
                    if (!h.getName().equals("Retry-After")) continue;
                    String retry_time = h.getValue();
                    try {
                        Thread.sleep(Integer.parseInt(retry_time) * 1000);
                    }
                    catch (NumberFormatException e) {
                        this.config.getLogger().warn((Object)("Cannot parse " + retry_time + " to Integer"), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        this.config.getLogger().debug((Object)e.getMessage(), (Throwable)e);
                    }
                    httpclient.getConnectionManager().shutdown();
                    httpclient = new DefaultHttpClient();
                    response = httpclient.execute((HttpUriRequest)httpget);
                }
            }
            HttpEntity entity = response.getEntity();
            InputStream instream = entity.getContent();
            OAIPMHtype res = OAIPMHParser.parse(instream, this.config);
            return res.getListMetadataFormats();
        }
        catch (IOException e) {
            throw new InternalHarvestException(e);
        }
        catch (ParseException e) {
            throw new InternalHarvestException(e);
        }
    }

    public boolean hasNext() throws NoMetadataFormatsException, IdDoesNotExistException, InternalHarvestException {
        if (this._queue == null) {
            if (this._queue == null) {
                this._queue = new LinkedList<MetadataFormatType>();
            }
            this.harvest();
        }
        return this._queue.size() > 0;
    }

    public MetadataFormatType next() {
        return this._queue.poll();
    }
}

