/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse;

import com.lyncode.xoai.dataprovider.xml.read.XmlReader;
import com.lyncode.xoai.dataprovider.xml.read.XmlReaderException;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.Configuration;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.ConditionConfigurationParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.ContextConfigurationParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.FilterConfigurationParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.FormatConfigurationParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.ParseException;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.Parser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.SetConfigurationParser;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parse.TransformerConfigurationParser;

public class ConfigurationParser
extends Parser<Configuration> {
    private final ContextConfigurationParser contextConfigurationParser = new ContextConfigurationParser();
    private final FormatConfigurationParser formatConfigurationParser = new FormatConfigurationParser();
    private final TransformerConfigurationParser transformerConfigurationParser = new TransformerConfigurationParser();
    private final FilterConfigurationParser filterConfigurationParser = new FilterConfigurationParser();
    private final ConditionConfigurationParser conditionConfigurationParser = new ConditionConfigurationParser();
    private final SetConfigurationParser setConfigurationParser = new SetConfigurationParser();

    @Override
    public Configuration parse(XmlReader reader) throws ParseException {
        try {
            reader.proceedToTheNextStartElement();
            Configuration configuration = new Configuration().withMaxListIdentifiersSize(Integer.valueOf(reader.getAttribute("maxListIdentifiersSize"))).withMaxListRecordsSize(Integer.valueOf(reader.getAttribute("maxListRecordsSize"))).withMaxListSetsSize(Integer.valueOf(reader.getAttribute("maxListSetsSize"))).withIndented(Boolean.valueOf(reader.getAttribute("indented"))).withStylesheet(reader.getAttribute("stylesheet")).withDescriptionFile(reader.getAttribute("descriptionFile"));
            reader.proceedToNextElement();
            while (reader.isStart()) {
                if (reader.elementNameIs("Contexts")) {
                    reader.proceedToNextElement();
                    while (reader.isStart() && reader.getName().equals("Context")) {
                        configuration.withContextConfigurations(this.contextConfigurationParser.parse(reader));
                    }
                    reader.proceedToNextElement();
                    continue;
                }
                if (reader.elementNameIs("Formats")) {
                    reader.proceedToNextElement();
                    while (reader.isStart()) {
                        configuration.withFormatConfigurations(this.formatConfigurationParser.parse(reader));
                    }
                    reader.proceedToNextElement();
                    continue;
                }
                if (reader.elementNameIs("Transformers")) {
                    reader.proceedToNextElement();
                    while (reader.isStart()) {
                        configuration.withTransformerConfigurations(this.transformerConfigurationParser.parse(reader));
                    }
                    reader.proceedToNextElement();
                    continue;
                }
                if (reader.elementNameIs("Filters")) {
                    reader.proceedToNextElement();
                    while (reader.isStart()) {
                        if (reader.elementNameIs("Filter")) {
                            configuration.withFilters(this.filterConfigurationParser.parse(reader));
                            continue;
                        }
                        if (!reader.elementNameIs("CustomCondition")) continue;
                        configuration.withConditions(this.conditionConfigurationParser.parse(reader));
                    }
                    reader.proceedToNextElement();
                    continue;
                }
                if (reader.elementNameIs("Sets")) {
                    reader.proceedToNextElement();
                    while (reader.isStart()) {
                        configuration.withSets(this.setConfigurationParser.parse(reader));
                    }
                    reader.proceedToNextElement();
                    continue;
                }
                throw new ParseException("Unexpected element " + reader.getName());
            }
            return configuration;
        }
        catch (XmlReaderException e) {
            throw new ParseException(e);
        }
    }
}

