/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters;

import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class ParameterMap
extends ParameterValue<Map<String, Object>> {
    private List<ParameterValue> values;

    public List<ParameterValue> getValues() {
        return this.values;
    }

    public ParameterValue get(String key) {
        for (ParameterValue value : this.values) {
            if (!value.hasName() || !value.getName().equals(key)) continue;
            return value;
        }
        return null;
    }

    public ParameterMap withValues(Collection<ParameterValue> values) {
        if (this.values == null) {
            this.values = new ArrayList<ParameterValue>();
        }
        this.values.addAll(values);
        return this;
    }

    public ParameterMap withValues(ParameterValue ... values) {
        if (this.values == null) {
            this.values = new ArrayList<ParameterValue>();
        }
        this.values.addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public void write(XmlOutputContext writer) throws WritingXmlException {
        try {
            writer.getWriter().writeStartElement("map");
            if (this.hasName()) {
                writer.getWriter().writeAttribute("name", this.getName());
            }
            for (ParameterValue value : this.getValues()) {
                value.write(writer);
            }
            writer.getWriter().writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WritingXmlException(e);
        }
    }
}

