/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoaiconfig;

import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XMLWritable;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.Referable;
import javax.xml.stream.XMLStreamException;

public class TransformerConfiguration
implements Referable,
XMLWritable {
    private String xslt;
    private String description;
    private String id;

    public TransformerConfiguration(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void write(XmlOutputContext writer) throws WritingXmlException {
        if (this.xslt == null) {
            throw new WritingXmlException("Transformer XSLT field is mandatory");
        }
        try {
            writer.getWriter().writeStartElement("Transformer");
            writer.getWriter().writeAttribute("id", this.id);
            writer.getWriter().writeStartElement("XSLT");
            writer.getWriter().writeCharacters(this.xslt);
            writer.getWriter().writeEndElement();
            if (this.hasDescription()) {
                writer.getWriter().writeStartElement("Description");
                writer.getWriter().writeCharacters(this.description);
                writer.getWriter().writeEndElement();
            }
            writer.getWriter().writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WritingXmlException(e);
        }
    }

    private boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getXslt() {
        return this.xslt;
    }

    public TransformerConfiguration withDescription(String description) {
        this.description = description;
        return this;
    }

    public TransformerConfiguration withXslt(String xslt) {
        this.xslt = xslt;
        return this;
    }
}

