/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoaiconfig;

import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XMLWritable;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.BundleReference;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.Referable;
import javax.xml.stream.XMLStreamException;

public class FormatConfiguration
implements XMLWritable,
Referable {
    private String prefix;
    private String xslt;
    private String namespace;
    private String schemaLocation;
    private BundleReference filter;
    private String id;

    public FormatConfiguration(String id) {
        this.id = id;
    }

    @Override
    public void write(XmlOutputContext writer) throws WritingXmlException {
        this.validate();
        try {
            writer.getWriter().writeStartElement("Format");
            writer.getWriter().writeAttribute("id", this.id);
            writer.getWriter().writeStartElement("Prefix");
            writer.getWriter().writeCharacters(this.prefix);
            writer.getWriter().writeEndElement();
            writer.getWriter().writeStartElement("XSLT");
            writer.getWriter().writeCharacters(this.xslt);
            writer.getWriter().writeEndElement();
            writer.getWriter().writeStartElement("Namespace");
            writer.getWriter().writeCharacters(this.namespace);
            writer.getWriter().writeEndElement();
            writer.getWriter().writeStartElement("SchemaLocation");
            writer.getWriter().writeCharacters(this.schemaLocation);
            writer.getWriter().writeEndElement();
            if (this.hasFilter()) {
                writer.getWriter().writeStartElement("Filter");
                this.filter.write(writer);
                writer.getWriter().writeEndElement();
            }
            writer.getWriter().writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WritingXmlException(e);
        }
    }

    private void validate() throws WritingXmlException {
        if (this.prefix == null) {
            throw new WritingXmlException("FormatConfiguration XSLT prefix is mandatory");
        }
        if (this.xslt == null) {
            throw new WritingXmlException("FormatConfiguration XSLT field is mandatory");
        }
        if (this.namespace == null) {
            throw new WritingXmlException("FormatConfiguration XSLT namespace is mandatory");
        }
        if (this.schemaLocation == null) {
            throw new WritingXmlException("FormatConfiguration XSLT schemaLocation is mandatory");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getXslt() {
        return this.xslt;
    }

    public BundleReference getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public FormatConfiguration withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public FormatConfiguration withXslt(String xslt) {
        this.xslt = xslt;
        return this;
    }

    public FormatConfiguration withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public FormatConfiguration withSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    public FormatConfiguration withFilter(String filterId) {
        this.filter = new BundleReference(filterId);
        return this;
    }
}

