/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoai;

import com.lyncode.xoai.dataprovider.xml.xoai.Element;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLInputFactory2;

public class XOAIParser {
    private static final String METADATA = "metadata";
    private static final String FIELD = "field";
    private static final String ELEMENT = "element";
    private static XMLInputFactory factory = XMLInputFactory2.newFactory();
    private XMLEventReader reader;
    private Metadata metadata;
    private Stack<Element> stack;

    public static Metadata parse(InputStream st) throws XMLStreamException {
        XOAIParser parser = new XOAIParser(st);
        return parser.parse();
    }

    public XOAIParser(InputStream stream) throws XMLStreamException {
        this.reader = factory.createXMLEventReader(stream);
        this.metadata = null;
        this.stack = new Stack();
    }

    public Metadata parse() throws XMLStreamException {
        if (this.metadata != null) {
            return this.metadata;
        }
        this.metadata = new Metadata();
        boolean started = false;
        while (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextTag();
            if (event == null) {
                return this.metadata;
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().toLowerCase().equals(METADATA)) {
                if (started) {
                    throw new XMLStreamException("Wrong schema");
                }
                started = true;
            }
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().toLowerCase().equals(ELEMENT)) continue;
            this.stack.push(new Element());
            this.stack.peek().setName(this.getName(event.asStartElement()));
            this.parseElement();
            this.metadata.getElement().add(this.stack.pop());
        }
        return this.metadata;
    }

    private void parseElement() throws XMLStreamException {
        boolean end = false;
        while (!end) {
            XMLEvent event = this.reader.nextTag();
            if (event == null) {
                return;
            }
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().toLowerCase().equals(ELEMENT)) {
                end = true;
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().toLowerCase().equals(ELEMENT)) {
                this.stack.push(new Element());
                this.stack.peek().setName(this.getName(event.asStartElement()));
                this.parseElement();
                Element newElem = this.stack.pop();
                this.stack.peek().getElement().add(newElem);
            }
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().toLowerCase().equals(FIELD)) continue;
            this.parseField(event);
        }
    }

    private String getName(StartElement asStartElement) {
        Iterator<Attribute> it = asStartElement.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            if (!attr.getName().getLocalPart().toLowerCase().equals("name")) continue;
            return attr.getValue();
        }
        return null;
    }

    private void parseField(XMLEvent event) throws XMLStreamException {
        Element.Field f = new Element.Field();
        f.setName(this.getName(event.asStartElement()));
        f.setValue(this.reader.getElementText());
        this.stack.peek().getField().add(f);
    }
}

