/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.oaipmh;

import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XMLWritable;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.oaipmh.DeletedRecordType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.DescriptionType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.GranularityType;
import com.lyncode.xoai.util.XmlIOUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.stream.XMLStreamException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="IdentifyType", propOrder={"repositoryName", "baseURL", "protocolVersion", "adminEmail", "earliestDatestamp", "deletedRecord", "granularity", "compression", "description"})
public class IdentifyType
implements XMLWritable {
    @XmlElement(required=true)
    protected String repositoryName;
    @XmlElement(required=true)
    @XmlSchemaType(name="anyURI")
    protected String baseURL;
    @XmlElement(required=true)
    protected String protocolVersion;
    @XmlElement(required=true)
    protected List<String> adminEmail;
    @XmlElement(required=true)
    protected Date earliestDatestamp;
    @XmlElement(required=true)
    protected DeletedRecordType deletedRecord;
    @XmlElement(required=true)
    protected GranularityType granularity;
    protected List<String> compression;
    protected List<DescriptionType> description;

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String value) {
        this.repositoryName = value;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String value) {
        this.baseURL = value;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String value) {
        this.protocolVersion = value;
    }

    public List<String> getAdminEmail() {
        if (this.adminEmail == null) {
            this.adminEmail = new ArrayList<String>();
        }
        return this.adminEmail;
    }

    public Date getEarliestDatestamp() {
        return this.earliestDatestamp;
    }

    public void setEarliestDatestamp(Date value) {
        this.earliestDatestamp = value;
    }

    public DeletedRecordType getDeletedRecord() {
        return this.deletedRecord;
    }

    public void setDeletedRecord(DeletedRecordType value) {
        this.deletedRecord = value;
    }

    public GranularityType getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityType value) {
        this.granularity = value;
    }

    public List<String> getCompression() {
        if (this.compression == null) {
            this.compression = new ArrayList<String>();
        }
        return this.compression;
    }

    public List<DescriptionType> getDescription() {
        if (this.description == null) {
            this.description = new ArrayList<DescriptionType>();
        }
        return this.description;
    }

    @Override
    public void write(XmlOutputContext writer) throws WritingXmlException {
        if (this.repositoryName == null) {
            throw new WritingXmlException("Repository Name cannot be null");
        }
        if (this.baseURL == null) {
            throw new WritingXmlException("Base URL cannot be null");
        }
        if (this.protocolVersion == null) {
            throw new WritingXmlException("Protocol version cannot be null");
        }
        if (this.earliestDatestamp == null) {
            throw new WritingXmlException("Eerliest datestamp cannot be null");
        }
        if (this.deletedRecord == null) {
            throw new WritingXmlException("Deleted record persistency cannot be null");
        }
        if (this.granularity == null) {
            throw new WritingXmlException("Granularity cannot be null");
        }
        if (this.adminEmail == null || this.adminEmail.isEmpty()) {
            throw new WritingXmlException("List of admin emails cannot be null or empty");
        }
        try {
            XmlIOUtils.writeValue(writer.getWriter(), "repositoryName", this.repositoryName);
            XmlIOUtils.writeValue(writer.getWriter(), "baseURL", this.baseURL);
            XmlIOUtils.writeValue(writer.getWriter(), "protocolVersion", this.protocolVersion);
            for (String email : this.adminEmail) {
                XmlIOUtils.writeValue(writer.getWriter(), "adminEmail", email);
            }
            XmlIOUtils.writeValue(writer.getWriter(), "earliestDatestamp", writer.format(this.earliestDatestamp));
            XmlIOUtils.writeValue(writer.getWriter(), "deletedRecord", this.deletedRecord.value());
            XmlIOUtils.writeValue(writer.getWriter(), "granularity", this.granularity.value());
            if (this.compression != null && !this.compression.isEmpty()) {
                for (String comp : this.compression) {
                    XmlIOUtils.writeValue(writer.getWriter(), "compression", comp);
                }
            }
            if (this.description != null && !this.description.isEmpty()) {
                for (DescriptionType desc : this.description) {
                    writer.getWriter().writeStartElement("description");
                    desc.write(writer);
                    writer.getWriter().writeEndElement();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new WritingXmlException(e);
        }
    }
}

