/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.core;

import com.lyncode.xoai.dataprovider.core.XOAIContext;
import com.lyncode.xoai.dataprovider.data.internal.MetadataFormat;
import com.lyncode.xoai.dataprovider.data.internal.MetadataTransformer;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.filter.FilterManager;
import com.lyncode.xoai.dataprovider.format.MetadataFormatManager;
import com.lyncode.xoai.dataprovider.sets.StaticSet;
import com.lyncode.xoai.dataprovider.sets.StaticSetManager;
import com.lyncode.xoai.dataprovider.transform.TransformManager;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.BundleReference;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.ContextConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContextManager {
    private Map<String, XOAIContext> contexts = new HashMap<String, XOAIContext>();

    public ContextManager(List<ContextConfiguration> contexts, FilterManager filterManager, TransformManager tm, MetadataFormatManager mfm, StaticSetManager sm) throws ConfigurationException {
        for (ContextConfiguration contextConfiguration : contexts) {
            MetadataTransformer transformer = new MetadataTransformer();
            if (contextConfiguration.getTransformers() != null && contextConfiguration.getTransformers().getReference() != null) {
                transformer = tm.getTransformer(contextConfiguration.getTransformers().getReference());
            }
            ArrayList<StaticSet> sets = new ArrayList<StaticSet>();
            for (BundleReference bundleReference : contextConfiguration.getSets()) {
                if (!sm.setExists(bundleReference.getReference())) {
                    throw new ConfigurationException("Set referred as " + bundleReference.getReference() + " does not exist");
                }
                sets.add(sm.getSet(bundleReference.getReference()));
            }
            ArrayList<MetadataFormat> formats = new ArrayList<MetadataFormat>();
            for (BundleReference b3 : contextConfiguration.getFormats()) {
                if (!mfm.formatExists(b3.getReference())) {
                    throw new ConfigurationException("Metadata FormatConfiguration referred as " + b3.getReference() + " does not exist");
                }
                formats.add(mfm.getFormat(b3.getReference()));
            }
            XOAIContext xOAIContext = new XOAIContext(contextConfiguration.getBaseUrl(), contextConfiguration.getName(), contextConfiguration.getDescription(), transformer, formats, sets);
            if (contextConfiguration.hasFilter()) {
                xOAIContext.setCondition(filterManager.getFilter(contextConfiguration.getFilters().getReference()));
            }
            this.contexts.put(contextConfiguration.getBaseUrl(), xOAIContext);
        }
    }

    public boolean contextExists(String baseUrl) {
        return this.contexts.containsKey(baseUrl);
    }

    public XOAIContext getOAIContext(String baseUrl) {
        return this.contexts.get(baseUrl);
    }

    public Collection<XOAIContext> getContexts() {
        return this.contexts.values();
    }
}

