/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.kiesession.session.StatefulSessionPool;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.KieSessionsPool;

public abstract class AbstractKieSessionsPool
implements KieSessionsPool {
    private volatile boolean alive = true;
    protected final int initialSize;
    private final Map<String, StatefulSessionPool> pools = new ConcurrentHashMap<String, StatefulSessionPool>();
    protected final Environment environment = EnvironmentFactory.newEnvironment();

    protected AbstractKieSessionsPool(int initialSize) {
        this.initialSize = initialSize;
    }

    public void shutdown() {
        this.alive = false;
        this.pools.values().forEach(StatefulSessionPool::shutdown);
        this.pools.clear();
    }

    protected StatefulSessionPool getPool(KieSessionConfiguration conf, boolean stateless) {
        return this.getPool(null, conf, stateless);
    }

    protected StatefulSessionPool getPool(String kSessionName, KieSessionConfiguration conf, boolean stateless) {
        this.checkAlive();
        return this.pools.computeIfAbsent(this.getKey(kSessionName, conf, stateless), k -> this.createStatefulSessionPool(kSessionName, conf, stateless));
    }

    private void checkAlive() {
        if (!this.alive) {
            throw new IllegalStateException("Illegal method call. This session pool was previously disposed.");
        }
    }

    protected abstract StatefulSessionPool createStatefulSessionPool(String var1, KieSessionConfiguration var2, boolean var3);

    protected abstract String getKey(String var1, KieSessionConfiguration var2, boolean var3);
}

