/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.agenda;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.drools.base.common.NetworkNode;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.AgendaGroupsManager;
import org.drools.core.common.InternalActivationGroup;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.RuleFlowGroup;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.phreak.ExecutableEntry;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.core.util.CompositeIterator;
import org.drools.kiesession.agenda.DefaultAgenda;
import org.drools.kiesession.agenda.PartitionedDefaultAgenda;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.internal.concurrent.ExecutorProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDefaultAgenda
implements Externalizable,
InternalAgenda {
    protected static final transient Logger log = LoggerFactory.getLogger(CompositeDefaultAgenda.class);
    private static final ExecutorService EXECUTOR = ExecutorProviderFactory.getExecutorProvider().getExecutor();
    private static final AtomicBoolean FIRING_UNTIL_HALT_USING_EXECUTOR = new AtomicBoolean(false);
    private final DefaultAgenda[] agendas = new DefaultAgenda[RuleBasePartitionId.PARALLEL_PARTITIONS_NUMBER];
    private final DefaultAgenda.ExecutionStateMachine executionStateMachine = new DefaultAgenda.ConcurrentExecutionStateMachine();
    private PropagationList propagationList;

    public CompositeDefaultAgenda() {
    }

    public CompositeDefaultAgenda(InternalRuleBase kBase) {
        this(kBase, true);
    }

    public CompositeDefaultAgenda(InternalRuleBase kBase, boolean initMain) {
        for (int i = 0; i < this.agendas.length; ++i) {
            this.agendas[i] = new PartitionedDefaultAgenda(kBase, initMain, this.executionStateMachine, i);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        for (DefaultAgenda agenda : this.agendas) {
            out.writeObject(agenda);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        for (int i = 0; i < this.agendas.length; ++i) {
            this.agendas[i] = (DefaultAgenda)in.readObject();
        }
    }

    public DefaultAgenda getPartitionedAgenda(int partitionNr) {
        return this.agendas[partitionNr];
    }

    public DefaultAgenda getPartitionedAgendaForNode(NetworkNode node) {
        return this.getPartitionedAgenda(node.getPartitionId().getParallelEvaluationSlot());
    }

    public InternalWorkingMemory getWorkingMemory() {
        return this.agendas[0].getWorkingMemory();
    }

    public ReteEvaluator getReteEvaluator() {
        return this.agendas[0].getWorkingMemory();
    }

    public AgendaGroupsManager getAgendaGroupsManager() {
        return this.agendas[0].getAgendaGroupsManager();
    }

    public AgendaEventSupport getAgendaEventSupport() {
        return this.agendas[0].getAgendaEventSupport();
    }

    public RuleAgendaItem peekNextRule() {
        return this.getAgendaGroupsManager().peekNextRule();
    }

    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        Stream.of(this.agendas).forEach(a -> a.setWorkingMemory(workingMemory));
        this.propagationList = this.agendas[0].getPropagationList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        if (!this.executionStateMachine.toFireAllRules()) {
            return 0;
        }
        if (log.isTraceEnabled()) {
            log.trace("Starting Fire All Rules");
        }
        int fireCount = 0;
        try {
            boolean limitReached;
            int iterationFireCount = this.parallelFire(agendaFilter, fireLimit);
            boolean bl = limitReached = fireLimit > 0 && (fireCount += iterationFireCount) >= fireLimit;
            while (iterationFireCount > 0 && !limitReached && this.hasPendingPropagations()) {
                iterationFireCount = this.parallelFire(agendaFilter, fireLimit - fireCount);
                limitReached = fireLimit > 0 && (fireCount += iterationFireCount) >= fireLimit;
            }
        }
        finally {
            this.executionStateMachine.immediateHalt(this.propagationList);
        }
        if (log.isTraceEnabled()) {
            log.trace("Ending Fire All Rules");
        }
        return fireCount;
    }

    private int parallelFire(AgendaFilter agendaFilter, int fireLimit) {
        CompletableFuture[] results = new CompletableFuture[this.agendas.length - 1];
        int i = 0;
        while (i < results.length) {
            int j = i++;
            results[j] = CompletableFuture.supplyAsync(() -> this.agendas[j].internalFireAllRules(agendaFilter, fireLimit, false), EXECUTOR);
        }
        int result = this.agendas[this.agendas.length - 1].internalFireAllRules(agendaFilter, fireLimit, false);
        for (int i2 = 0; i2 < results.length; ++i2) {
            result += ((Integer)results[i2].join()).intValue();
        }
        return result;
    }

    public RuleAgendaItem createRuleAgendaItem(int salience, PathMemory rs, TerminalNode rtn) {
        return this.getPartitionedAgendaForNode((NetworkNode)rtn).createRuleAgendaItem(salience, rs, rtn);
    }

    public InternalMatch createAgendaItem(RuleTerminalNodeLeftTuple rtnLeftTuple, int salience, PropagationContext context, RuleAgendaItem ruleAgendaItem, InternalAgendaGroup agendaGroup) {
        return this.getPartitionedAgendaForNode((NetworkNode)ruleAgendaItem.getTerminalNode()).createAgendaItem(rtnLeftTuple, salience, context, ruleAgendaItem, agendaGroup);
    }

    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        ExecutorService fireUntilHaltExecutor = EXECUTOR;
        if (FIRING_UNTIL_HALT_USING_EXECUTOR.getAndSet(true)) {
            fireUntilHaltExecutor = ExecutorProviderFactory.getExecutorProvider().newFixedThreadPool();
        }
        if (log.isTraceEnabled()) {
            log.trace("Starting Fire Until Halt");
        }
        if (this.executionStateMachine.toFireUntilHalt()) {
            try {
                while (this.isFiring()) {
                    CompletableFuture[] futures = new CompletableFuture[this.agendas.length - 1];
                    int i = 0;
                    while (i < futures.length) {
                        int j = i++;
                        futures[j] = CompletableFuture.runAsync(() -> this.agendas[j].internalFireUntilHalt(agendaFilter, false), fireUntilHaltExecutor);
                    }
                    this.agendas[this.agendas.length - 1].internalFireUntilHalt(agendaFilter, false);
                    for (i = 0; i < futures.length; ++i) {
                        futures[i].join();
                    }
                }
            }
            finally {
                this.executionStateMachine.immediateHalt(this.propagationList);
                if (fireUntilHaltExecutor == EXECUTOR) {
                    FIRING_UNTIL_HALT_USING_EXECUTOR.set(false);
                } else {
                    fireUntilHaltExecutor.shutdown();
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Ending Fire Until Halt");
        }
    }

    public boolean dispose(InternalWorkingMemory wm) {
        for (int i = 0; i < this.agendas.length; ++i) {
            this.agendas[i].getPropagationList().dispose();
        }
        return this.executionStateMachine.dispose(wm);
    }

    public boolean isAlive() {
        return this.executionStateMachine.isAlive();
    }

    public void halt() {
        if (this.isFiring()) {
            this.propagationList.addEntry((PropagationEntry)new CompositeHalt(this.executionStateMachine, this));
        }
    }

    public boolean isFiring() {
        return this.executionStateMachine.isFiring();
    }

    public void addPropagation(PropagationEntry propagationEntry) {
        if (propagationEntry.isPartitionSplittable()) {
            for (int i = 0; i < this.agendas.length; ++i) {
                this.agendas[i].addPropagation(propagationEntry.getSplitForPartition(i));
            }
        } else {
            this.propagationList.addEntry(propagationEntry);
        }
    }

    public void flushPropagations() {
        for (int i = 0; i < this.agendas.length; ++i) {
            this.agendas[i].flushPropagations();
        }
    }

    public void notifyWaitOnRest() {
        for (int i = 0; i < this.agendas.length; ++i) {
            this.agendas[i].notifyWaitOnRest();
        }
    }

    public Iterator<PropagationEntry> getActionsIterator() {
        return new CompositeIterator((Iterator[])Stream.of(this.agendas).map(DefaultAgenda::getActionsIterator).toArray(Iterator[]::new));
    }

    public boolean hasPendingPropagations() {
        for (int i = 0; i < this.agendas.length; ++i) {
            if (!this.agendas[i].hasPendingPropagations()) continue;
            return true;
        }
        return false;
    }

    public void handleException(InternalMatch internalMatch, Exception e) {
        this.agendas[0].handleException(internalMatch, e);
    }

    public void clear() {
        for (int i = 0; i < this.agendas.length; ++i) {
            this.agendas[i].clear();
        }
    }

    public void reset() {
        for (int i = 0; i < this.agendas.length; ++i) {
            this.agendas[i].reset();
        }
    }

    public void executeTask(ExecutableEntry executable) {
        this.agendas[0].executeTask(executable);
    }

    public void executeFlush() {
        if (!this.executionStateMachine.toExecuteTaskState()) {
            return;
        }
        try {
            for (int i = 0; i < this.agendas.length; ++i) {
                this.agendas[i].flushPropagations();
            }
        }
        finally {
            this.executionStateMachine.immediateHalt(this.propagationList);
        }
    }

    public void activate() {
        this.agendas[0].activate();
    }

    public void deactivate() {
        this.agendas[0].deactivate();
    }

    public boolean tryDeactivate() {
        return this.agendas[0].tryDeactivate();
    }

    public void activateRuleFlowGroup(String name) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.activateRuleFlowGroup -> TODO");
    }

    public void activateRuleFlowGroup(String name, String processInstanceId, String nodeInstanceId) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.activateRuleFlowGroup -> TODO");
    }

    public void clearAndCancel() {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.clearAndCancel -> TODO");
    }

    public void clearAndCancelAgendaGroup(String name) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.clearAndCancelAgendaGroup -> TODO");
    }

    public void clearAndCancelActivationGroup(String name) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.clearAndCancelActivationGroup -> TODO");
    }

    public void clearAndCancelActivationGroup(InternalActivationGroup activationGroup) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.clearAndCancelActivationGroup -> TODO");
    }

    public void clearAndCancelRuleFlowGroup(String name) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.clearAndCancelRuleFlowGroup -> TODO");
    }

    public String getFocusName() {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.getFocusName -> TODO");
    }

    public int fireNextItem(AgendaFilter filter, int fireCount, int fireLimit) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.fireNextItem -> TODO");
    }

    public void cancelActivation(InternalMatch internalMatch) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.cancelActivation -> TODO");
    }

    public boolean isDeclarativeAgenda() {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.isDeclarativeAgenda -> TODO");
    }

    public InternalAgendaGroup getAgendaGroup(String name) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.getAgendaGroup -> TODO");
    }

    public void setFocus(String name) {
        for (int i = 0; i < this.agendas.length; ++i) {
            this.agendas[i].setFocus(name);
        }
    }

    public InternalActivationGroup getActivationGroup(String name) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.getActivationGroup -> TODO");
    }

    public RuleFlowGroup getRuleFlowGroup(String name) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.getRuleFlowGroup -> TODO");
    }

    public void setActivationsFilter(ActivationsFilter filter) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.setActivationsFilter -> TODO");
    }

    public ActivationsFilter getActivationsFilter() {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.getActivationsFilter -> TODO");
    }

    public void addEagerRuleAgendaItem(RuleAgendaItem item) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.addEagerRuleAgendaItem -> TODO");
    }

    public void removeEagerRuleAgendaItem(RuleAgendaItem item) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.removeEagerRuleAgendaItem -> TODO");
    }

    public void addQueryAgendaItem(RuleAgendaItem item) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.addQueryAgendaItem -> TODO");
    }

    public void removeQueryAgendaItem(RuleAgendaItem item) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.removeQueryAgendaItem -> TODO");
    }

    public void stageLeftTuple(RuleAgendaItem ruleAgendaItem, InternalMatch justified) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.stageLeftTuple -> TODO");
    }

    public void evaluateEagerList() {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.evaluateEagerList -> TODO");
    }

    public void evaluateQueriesForRule(RuleAgendaItem item) {
        throw new UnsupportedOperationException();
    }

    public Map<String, InternalActivationGroup> getActivationGroupsMap() {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.getActivationGroupsMap -> TODO");
    }

    public int sizeOfRuleFlowGroup(String s) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.sizeOfRuleFlowGroup -> TODO");
    }

    public void addItemToActivationGroup(InternalMatch item) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.addItemToActivationGroup -> TODO");
    }

    public boolean isRuleActiveInRuleFlowGroup(String ruleflowGroupName, String ruleName, String processInstanceId) {
        throw new UnsupportedOperationException("org.drools.core.common.CompositeDefaultAgenda.isRuleActiveInRuleFlowGroup -> TODO");
    }

    public void registerExpiration(PropagationContext expirationContext) {
        throw new UnsupportedOperationException("This method has to be called on the single partitioned agendas");
    }

    public KnowledgeHelper getKnowledgeHelper() {
        throw new UnsupportedOperationException("This method has to be called on the single partitioned agendas");
    }

    public boolean isParallelAgenda() {
        return true;
    }

    static class CompositeHalt
    extends DefaultAgenda.Halt {
        private final CompositeDefaultAgenda compositeAgenda;

        protected CompositeHalt(DefaultAgenda.ExecutionStateMachine executionStateMachine, CompositeDefaultAgenda compositeAgenda) {
            super(executionStateMachine);
            this.compositeAgenda = compositeAgenda;
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            super.internalExecute(reteEvaluator);
            this.compositeAgenda.notifyWaitOnRest();
        }
    }
}

