/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.builder.InternalKnowledgeBuilder;
import org.drools.compiler.kie.builder.impl.IncrementalResultsImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.io.impl.BaseResource;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.KieBuilderSet;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.kie.memorycompiler.resources.KiePath;

public class KieBuilderSetImpl
implements KieBuilderSet {
    private final KieBuilderImpl kieBuilder;
    private final Message.Level minimalLevel;
    private String[] files;
    private Map<String, Collection<KnowledgeBuilderResult>> previousErrors;
    private final Map<String, Set<String>> resourcesWithErrors = new HashMap<String, Set<String>>();

    public KieBuilderSetImpl(KieBuilderImpl kieBuilder) {
        this(kieBuilder, Message.Level.ERROR);
        this.registerInitialErrors(kieBuilder);
    }

    public KieBuilderSetImpl(KieBuilderImpl kieBuilder, Message.Level minimalLevel) {
        this.kieBuilder = kieBuilder;
        this.minimalLevel = minimalLevel;
        this.registerInitialErrors(kieBuilder);
    }

    private void registerInitialErrors(KieBuilderImpl kieBuilder) {
        this.previousErrors = new HashMap<String, Collection<KnowledgeBuilderResult>>();
        InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModuleIgnoringErrors();
        for (KieBaseModel kBaseModel : kieModule.getKieModuleModel().getKieBaseModels().values()) {
            KnowledgeBuilder kBuilder = kieModule.getKnowledgeBuilderForKieBase(kBaseModel.getName());
            if (kBuilder == null) continue;
            this.previousErrors.put(kBaseModel.getName(), (Collection<KnowledgeBuilderResult>)kBuilder.getResults(this.getSeverities()));
            this.resourcesWithErrors.put(kBaseModel.getName(), this.findResourcesWithMessages(kBuilder));
        }
    }

    public Message.Level getMinimalLevel() {
        return this.minimalLevel;
    }

    private ResultSeverity[] getSeverities() {
        switch (this.minimalLevel) {
            case ERROR: {
                return new ResultSeverity[]{ResultSeverity.ERROR};
            }
            case WARNING: {
                return new ResultSeverity[]{ResultSeverity.ERROR, ResultSeverity.WARNING};
            }
            case INFO: {
                return new ResultSeverity[]{ResultSeverity.ERROR, ResultSeverity.WARNING, ResultSeverity.INFO};
            }
        }
        throw new UnsupportedOperationException("Unknow message level:  " + this.minimalLevel);
    }

    public KieBuilderSetImpl setFiles(String[] files) {
        this.files = files;
        return this;
    }

    public IncrementalResults build() {
        Collection<String> srcFiles = this.files != null ? Arrays.asList(this.files) : this.kieBuilder.getModifiedResourcesSinceLastMark();
        ArrayList<String> filesToBuild = new ArrayList<String>();
        if (srcFiles.isEmpty()) {
            return new IncrementalResultsImpl();
        }
        this.kieBuilder.cloneKieModuleForIncrementalCompilation();
        for (String file : srcFiles) {
            String trgFile;
            if (file.endsWith(".properties") || (trgFile = this.kieBuilder.copySourceToTarget(KiePath.of((String)file))) == null) continue;
            filesToBuild.add(trgFile);
        }
        IncrementalResults result = this.buildChanges(filesToBuild);
        this.files = null;
        this.kieBuilder.markSource();
        return result;
    }

    private Set<String> findResourcesWithMessages(KnowledgeBuilder kBuilder) {
        if (kBuilder.hasResults(this.getSeverities())) {
            HashSet<String> resourcesWithMessages = new HashSet<String>();
            for (KnowledgeBuilderResult result : kBuilder.getResults(this.getSeverities())) {
                resourcesWithMessages.add(result.getResource().getSourcePath());
            }
            return resourcesWithMessages;
        }
        return Collections.emptySet();
    }

    private IncrementalResults buildChanges(Collection<String> filesToBuild) {
        HashMap<String, Collection<KnowledgeBuilderResult>> currentResults = new HashMap<String, Collection<KnowledgeBuilderResult>>();
        InternalKieModule kieModule = (InternalKieModule)this.kieBuilder.getKieModuleIgnoringErrors();
        for (KieBaseModel kBaseModel : kieModule.getKieModuleModel().getKieBaseModels().values()) {
            boolean typeRefreshed;
            InternalKnowledgeBuilder kBuilder = (InternalKnowledgeBuilder)kieModule.getKnowledgeBuilderForKieBase(kBaseModel.getName());
            if (kBuilder == null) continue;
            CompositeKnowledgeBuilder ckbuilder = kBuilder.batch();
            boolean useFolders = kBuilder.getBuilderConfiguration().isGroupDRLsInKieBasesByFolder();
            InternalKnowledgeBuilder.ResourceRemovalResult removalResult = new InternalKnowledgeBuilder.ResourceRemovalResult();
            Set<String> wrongResources = this.resourcesWithErrors.get(kBaseModel.getName());
            for (String resourceName : wrongResources) {
                removalResult.add(kBuilder.removeObjectsGeneratedFromResource((Resource)new DummyResource(resourceName)));
                removalResult.mergeModified(this.addResource(ckbuilder, kBaseModel, kieModule, resourceName, useFolders));
            }
            for (String file : filesToBuild) {
                if (wrongResources.contains(file)) {
                    removalResult.mergeModified(true);
                    continue;
                }
                removalResult.add(kBuilder.removeObjectsGeneratedFromResource((Resource)new DummyResource(file)));
                removalResult.mergeModified(this.addResource(ckbuilder, kBaseModel, kieModule, file, useFolders));
            }
            if (!removalResult.isModified()) continue;
            boolean bl = typeRefreshed = !removalResult.getRemovedTypes().isEmpty();
            if (typeRefreshed) {
                ProjectClassLoader projectClassLoader = (ProjectClassLoader)kBuilder.getRootClassLoader();
                projectClassLoader.reinitTypes();
                for (String removedType : removalResult.getRemovedTypes()) {
                    projectClassLoader.undefineClass(removedType);
                }
            }
            ckbuilder.build();
            if (typeRefreshed) {
                Collection kiePackages = kBuilder.getKnowledgePackages();
                for (KiePackage kiePackage : kiePackages) {
                    ((InternalKnowledgePackage)kiePackage).wireStore();
                    ((InternalKnowledgePackage)kiePackage).wireTypeDeclarations();
                }
            }
            this.resourcesWithErrors.put(kBaseModel.getName(), this.findResourcesWithMessages(kBuilder));
            if (kBuilder.hasResults(this.getSeverities())) {
                currentResults.put(kBaseModel.getName(), (Collection<KnowledgeBuilderResult>)kBuilder.getResults(this.getSeverities()));
            }
            if (kBuilder.hasErrors()) {
                kBuilder.undo();
                continue;
            }
            KieServices.Factory.get().getRepository().addKieModule((KieModule)kieModule);
            this.kieBuilder.updateKieModuleMetaInfo();
        }
        IncrementalResultsImpl results = this.getIncrementalResults(currentResults);
        this.previousErrors = currentResults;
        return results;
    }

    private IncrementalResultsImpl getIncrementalResults(Map<String, Collection<KnowledgeBuilderResult>> currentResults) {
        IncrementalResultsImpl results = new IncrementalResultsImpl();
        for (Map.Entry<String, Collection<KnowledgeBuilderResult>> entry : currentResults.entrySet()) {
            Collection<KnowledgeBuilderResult> previousErrorsInKB = this.previousErrors.remove(entry.getKey());
            for (KnowledgeBuilderResult error : entry.getValue()) {
                if (previousErrorsInKB != null && previousErrorsInKB.remove(error)) continue;
                results.addMessage(error, entry.getKey());
            }
            if (previousErrorsInKB == null) continue;
            for (KnowledgeBuilderResult error : previousErrorsInKB) {
                results.removeMessage(error, entry.getKey());
            }
        }
        for (Map.Entry<String, Collection<KnowledgeBuilderResult>> entry : this.previousErrors.entrySet()) {
            for (KnowledgeBuilderResult error : entry.getValue()) {
                results.removeMessage(error, entry.getKey());
            }
        }
        return results;
    }

    private boolean addResource(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, InternalKieModule kieModule, String resourceName, boolean useFolders) {
        return !resourceName.endsWith(".properties") && KieBuilderImpl.filterFileInKBase(kieModule, kieBaseModel, resourceName, () -> kieModule.getResource(resourceName), useFolders) && kieModule.addResourceToCompiler(ckbuilder, kieBaseModel, resourceName);
    }

    public static class DummyResource
    extends BaseResource {
        public DummyResource(String resourceName) {
            this.setSourcePath(this.decode(resourceName));
        }

        public DummyResource() {
        }

        public URL getURL() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean hasURL() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        public Collection<Resource> listResources() {
            throw new UnsupportedOperationException();
        }

        public String getEncoding() {
            throw new UnsupportedOperationException();
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Reader getReader() throws IOException {
            throw new UnsupportedOperationException();
        }

        private String decode(String resourceName) {
            try {
                return URLDecoder.decode(resourceName, "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                return resourceName;
            }
        }
    }
}

