/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.List;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.builder.impl.processors.FilterCondition;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.util.StringUtils;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.internal.builder.ResourceChange;

public class FunctionCompiler
extends AbstractPackageCompilationPhase {
    private final FilterCondition filter;
    private ClassLoader rootClassLoader;

    public FunctionCompiler(PackageDescr packageDescr, PackageRegistry pkgRegistry, FilterCondition filter, ClassLoader rootClassLoader) {
        super(pkgRegistry, packageDescr);
        this.filter = filter;
        this.rootClassLoader = rootClassLoader;
    }

    @Override
    public void process() {
        List functions = this.packageDescr.getFunctions();
        if (!functions.isEmpty()) {
            for (FunctionDescr functionDescr : functions) {
                if (StringUtils.isEmpty((CharSequence)functionDescr.getNamespace())) {
                    functionDescr.setNamespace(this.packageDescr.getNamespace());
                }
                functionDescr.setDialect("java");
                this.preCompileAddFunction(functionDescr, this.pkgRegistry);
            }
            for (FunctionDescr functionDescr : functions) {
                if (!this.filter.accepts(ResourceChange.Type.FUNCTION, functionDescr.getNamespace(), functionDescr.getName())) continue;
                this.addFunction(functionDescr, this.pkgRegistry);
            }
            this.pkgRegistry.compileAll();
            for (FunctionDescr functionDescr : functions) {
                if (!this.filter.accepts(ResourceChange.Type.FUNCTION, functionDescr.getNamespace(), functionDescr.getName())) continue;
                this.postCompileAddFunction(functionDescr, this.pkgRegistry);
            }
        }
    }

    private void preCompileAddFunction(FunctionDescr functionDescr, PackageRegistry pkgRegistry) {
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.preCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
    }

    private void addFunction(FunctionDescr functionDescr, PackageRegistry pkgRegistry) {
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.addFunction(functionDescr, pkgRegistry.getTypeResolver(), null);
    }

    private void postCompileAddFunction(FunctionDescr functionDescr, PackageRegistry pkgRegistry) {
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.postCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
        if (this.rootClassLoader instanceof ProjectClassLoader) {
            String functionClassName = functionDescr.getClassName();
            JavaDialectRuntimeData runtime = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
            try {
                KnowledgeBaseImpl.registerFunctionClassAndInnerClasses((String)functionClassName, (JavaDialectRuntimeData)runtime, (arg_0, arg_1) -> ((ProjectClassLoader)((ProjectClassLoader)this.rootClassLoader)).storeClass(arg_0, arg_1));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

