/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.submail.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.dromara.sms4j.submail.config.SubMailConfig;
import org.dromara.sms4j.submail.utils.SubMailUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubMailSmsImpl
extends AbstractSmsBlend<SubMailConfig> {
    private static final Logger log = LoggerFactory.getLogger(SubMailSmsImpl.class);
    private int retry = 0;

    public SubMailSmsImpl(SubMailConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public SubMailSmsImpl(SubMailConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "mysubmail";
    }

    @Override
    public SmsResponse sendMessage(String phone, String content) {
        return this.getSmsResponse(Collections.singletonList(phone), content, ((SubMailConfig)this.getConfig()).getTemplateId(), null);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> vars) {
        if (MapUtil.isEmpty(vars)) {
            log.error("vars or content must be not null");
            throw new SmsBlendException("vars or content must be not null");
        }
        String content = vars.get("content");
        vars.remove("content");
        return this.getSmsResponse(Collections.singletonList(phone), content, ((SubMailConfig)this.getConfig()).getTemplateId(), vars);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> vars) {
        if (MapUtil.isEmpty(vars)) {
            log.error("vars or content must be not null");
            throw new SmsBlendException("vars or content must be not null");
        }
        String content = vars.get("content");
        vars.remove("content");
        return this.getSmsResponse(Collections.singletonList(phone), content, templateId, vars);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String content) {
        if (StrUtil.isBlank((CharSequence)content)) {
            log.error("vars or content must be not null");
            throw new SmsBlendException("vars or content must be not null");
        }
        return this.massTexting(phones, ((SubMailConfig)this.getConfig()).getTemplateId(), (LinkedHashMap)BeanUtil.copyProperties((Object)content, LinkedHashMap.class, (String[])new String[0]));
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> vars) {
        if (MapUtil.isEmpty(vars)) {
            log.error("vars or content must be not null");
            throw new SmsBlendException("vars or content must be not null");
        }
        String content = vars.get("content");
        vars.remove("content");
        return this.getSmsResponse(phones, content, templateId, vars);
    }

    private SmsResponse getSmsResponse(List<String> phones, String content, String templateId, LinkedHashMap<String, String> vars) {
        SmsResponse smsResponse;
        LinkedHashMap<String, Object> body;
        if (CollUtil.isEmpty(phones)) {
            log.error("phones must be not null");
            throw new SmsBlendException("phones must be not null");
        }
        SubMailConfig config = (SubMailConfig)this.getConfig();
        String url = config.getHost() + config.getAction();
        switch (config.getAction()) {
            case "send.json": {
                if (StrUtil.isBlank((CharSequence)content)) {
                    log.error("content must be not null");
                    throw new SmsBlendException("content must be not null");
                }
                body = this.buildSend(phones.get(0), content);
                break;
            }
            case "xsend.json": {
                body = this.buildXSend(phones.get(0), templateId, vars);
                break;
            }
            case "multisend.json": {
                if (StrUtil.isBlank((CharSequence)content)) {
                    log.error("content must be not null");
                    throw new SmsBlendException("content must be not null");
                }
                if (MapUtil.isEmpty(vars)) {
                    log.error("vars be not null");
                    throw new SmsBlendException("vars must be not null");
                }
                body = this.buildMultiSend(phones, content, vars);
                break;
            }
            case "multixsend.json": {
                if (MapUtil.isEmpty(vars)) {
                    log.error("vars be not null");
                    throw new SmsBlendException("vars must be not null");
                }
                body = this.buildMultiXSend(phones, templateId, vars);
                break;
            }
            case "batchsend.json": {
                if (StrUtil.isBlank((CharSequence)content)) {
                    log.error("vars or content must be not null");
                    throw new SmsBlendException("vars or content must be not null");
                }
                body = this.buildBatchSend(phones, content);
                break;
            }
            case "batchxsend.json": {
                if (MapUtil.isEmpty(vars)) {
                    log.error("vars be not null");
                    throw new SmsBlendException("vars must be not null");
                }
                body = this.buildBatchXSend(phones, templateId, vars);
                break;
            }
            default: {
                log.error("\u4e0d\u652f\u6301\u7684\u77ed\u4fe1\u53d1\u9001\u7c7b\u578b");
                throw new SmsBlendException("\u4e0d\u652f\u6301\u7684\u77ed\u4fe1\u53d1\u9001\u7c7b\u578b");
            }
        }
        try {
            smsResponse = this.getResponse(this.http.postJson(url, SubMailUtils.buildHeaders(), body));
            log.debug("\u77ed\u4fe1\u53d1\u9001\u7ed3\u679c: {}", (Object)JSONUtil.toJsonStr((Object)smsResponse));
        }
        catch (SmsBlendException e) {
            log.error(e.message, (Throwable)e);
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry == config.getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phones, content, templateId, vars);
    }

    private SmsResponse requestRetry(List<String> phones, String content, String templateId, LinkedHashMap<String, String> vars) {
        this.http.safeSleep(((SubMailConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.getSmsResponse(phones, content, templateId, vars);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        return SmsRespUtils.resp((Object)resJson, (boolean)"success".equals(resJson.getStr((Object)"status")), (String)this.getConfigId());
    }

    private LinkedHashMap<String, Object> buildSend(String phone, String content) {
        SubMailConfig config = (SubMailConfig)this.getConfig();
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("appid", config.getAccessKeyId());
        body.put("to", StrUtil.addPrefixIfNot((CharSequence)phone, (CharSequence)"+86"));
        content = StrUtil.isNotBlank((CharSequence)config.getSignature()) ? StrUtil.addPrefixIfNot((CharSequence)content, (CharSequence)("\u3010 " + config.getSignature() + "\u3011")) + StrUtil.sub((CharSequence)content, (int)0, (int)1000) : StrUtil.sub((CharSequence)content, (int)0, (int)1000);
        body.put("content", content);
        body.put("timestamp", this.timestamp());
        body.put("sign_type", config.getSignType());
        if (StrUtil.isNotBlank((CharSequence)config.getSignVersion())) {
            body.put("sign_version", config.getSignVersion());
        }
        body.put("sign_type", config.getSignType());
        String signature = SubMailUtils.signature(body, config.getSignType(), config.getAccessKeyId(), config.getAccessKeySecret(), "content");
        body.put("signature", signature);
        return body;
    }

    private LinkedHashMap<String, Object> buildXSend(String phone, String templateId, LinkedHashMap<String, String> vars) {
        SubMailConfig config = (SubMailConfig)this.getConfig();
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("appid", config.getAccessKeyId());
        body.put("to", StrUtil.addPrefixIfNot((CharSequence)phone, (CharSequence)"+86"));
        body.put("project", templateId);
        if (MapUtil.isNotEmpty(vars)) {
            body.put("vars", JSONUtil.toJsonStr(vars));
        }
        body.put("timestamp", this.timestamp());
        body.put("sign_type", config.getSignType());
        if (StrUtil.isNotBlank((CharSequence)config.getSignVersion())) {
            body.put("sign_version", config.getSignVersion());
        }
        body.put("sign_type", config.getSignType());
        String signature = SubMailUtils.signature(body, config.getSignType(), config.getAccessKeyId(), config.getAccessKeySecret(), "vars");
        body.put("signature", signature);
        return body;
    }

    private LinkedHashMap<String, Object> buildMultiSend(List<String> phones, String content, LinkedHashMap<String, String> vars) {
        SubMailConfig config = (SubMailConfig)this.getConfig();
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("appid", config.getAccessKeyId());
        content = StrUtil.isNotBlank((CharSequence)config.getSignature()) ? StrUtil.addPrefixIfNot((CharSequence)content, (CharSequence)("\u3010 " + config.getSignature() + "\u3011")) + StrUtil.sub((CharSequence)content, (int)0, (int)1000) : StrUtil.sub((CharSequence)content, (int)0, (int)1000);
        body.put("content", content);
        phones = CollUtil.sub(phones, (int)0, (int)50);
        ArrayList multi = new ArrayList(phones.size());
        phones.forEach(phone -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("to", StrUtil.addPrefixIfNot((CharSequence)phone, (CharSequence)"+86"));
            map.put("vars", vars);
            multi.add(map);
        });
        body.put("multi", JSONUtil.toJsonStr(multi));
        body.put("timestamp", this.timestamp());
        body.put("sign_type", config.getSignType());
        if (StrUtil.isNotBlank((CharSequence)config.getSignVersion())) {
            body.put("sign_version", config.getSignVersion());
        }
        body.put("sign_type", config.getSignType());
        String signature = SubMailUtils.signature(body, config.getSignType(), config.getAccessKeyId(), config.getAccessKeySecret(), "multi", "content");
        body.put("signature", signature);
        return body;
    }

    private LinkedHashMap<String, Object> buildMultiXSend(List<String> phones, String templateId, LinkedHashMap<String, String> vars) {
        SubMailConfig config = (SubMailConfig)this.getConfig();
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("appid", config.getAccessKeyId());
        body.put("project", templateId);
        phones = CollUtil.sub(phones, (int)0, (int)200);
        ArrayList multi = new ArrayList(phones.size());
        phones.forEach(phone -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("to", StrUtil.addPrefixIfNot((CharSequence)phone, (CharSequence)"+86"));
            map.put("vars", vars);
            multi.add(map);
        });
        body.put("multi", JSONUtil.toJsonStr(multi));
        body.put("timestamp", this.timestamp());
        body.put("sign_type", config.getSignType());
        if (StrUtil.isNotBlank((CharSequence)config.getSignVersion())) {
            body.put("sign_version", config.getSignVersion());
        }
        body.put("sign_type", config.getSignType());
        String signature = SubMailUtils.signature(body, config.getSignType(), config.getAccessKeyId(), config.getAccessKeySecret(), "multi", "content");
        body.put("signature", signature);
        return body;
    }

    private LinkedHashMap<String, Object> buildBatchSend(List<String> phones, String content) {
        SubMailConfig config = (SubMailConfig)this.getConfig();
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("appid", config.getAccessKeyId());
        phones = CollUtil.sub(phones, (int)0, (int)10000);
        body.put("to", SmsUtils.addCodePrefixIfNot((List)phones));
        content = StrUtil.isNotBlank((CharSequence)config.getSignature()) ? StrUtil.addPrefixIfNot((CharSequence)content, (CharSequence)("\u3010 " + config.getSignature() + "\u3011")) + StrUtil.sub((CharSequence)content, (int)0, (int)1000) : StrUtil.sub((CharSequence)content, (int)0, (int)1000);
        body.put("content", content);
        body.put("timestamp", this.timestamp());
        body.put("sign_type", config.getSignType());
        if (StrUtil.isNotBlank((CharSequence)config.getSignVersion())) {
            body.put("sign_version", config.getSignVersion());
        }
        body.put("sign_type", config.getSignType());
        String signature = SubMailUtils.signature(body, config.getSignType(), config.getAccessKeyId(), config.getAccessKeySecret(), "content");
        body.put("signature", signature);
        return body;
    }

    private LinkedHashMap<String, Object> buildBatchXSend(List<String> phones, String templateId, LinkedHashMap<String, String> vars) {
        SubMailConfig config = (SubMailConfig)this.getConfig();
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("appid", config.getAccessKeyId());
        phones = CollUtil.sub(phones, (int)0, (int)10000);
        body.put("to", SmsUtils.addCodePrefixIfNot((List)phones));
        body.put("project", templateId);
        if (MapUtil.isNotEmpty(vars)) {
            body.put("vars", JSONUtil.toJsonStr(vars));
        }
        body.put("timestamp", this.timestamp());
        body.put("sign_type", config.getSignType());
        if (StrUtil.isNotBlank((CharSequence)config.getSignVersion())) {
            body.put("sign_version", config.getSignVersion());
        }
        body.put("sign_type", config.getSignType());
        String signature = SubMailUtils.signature(body, config.getSignType(), config.getAccessKeyId(), config.getAccessKeySecret(), "vars");
        body.put("signature", signature);
        return body;
    }

    private String timestamp() {
        JSONObject resp = this.http.getUrl("https://api-v4.mysubmail.com/service/timestamp");
        return resp.getStr((Object)"timestamp");
    }
}

