/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.lianlu.utils;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class LianLuUtils {
    private static final Set<String> IGNORE_FILED_SET = new HashSet<String>();
    public static final String SIGN_TYPE_MD5 = "MD5";
    public static final String SIGN_TYPE_HMACSHA256 = "HMACSHA256";

    public static String generateSignature(TreeMap<String, Object> data, String key, String signType) {
        Set<String> keySet = data.keySet();
        StringBuilder sb = new StringBuilder();
        for (String k : keySet) {
            String value;
            Object v;
            if (IGNORE_FILED_SET.contains(k) || (v = data.get(k)) == null || !StrUtil.isNotBlank((CharSequence)(value = v.toString().trim()))) continue;
            sb.append(k).append("=").append(value).append("&");
        }
        sb.append("key=").append(key);
        if (SIGN_TYPE_HMACSHA256.equals(signType)) {
            return SecureUtil.hmacSha256((String)key).digestHex(sb.toString(), StandardCharsets.UTF_8).toUpperCase();
        }
        if (SIGN_TYPE_MD5.equals(signType)) {
            return SecureUtil.md5((String)sb.toString()).toUpperCase();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u65b9\u5f0f:" + signType);
    }

    static {
        IGNORE_FILED_SET.add("Signature");
        IGNORE_FILED_SET.add("PhoneList");
        IGNORE_FILED_SET.add("phoneSet");
        IGNORE_FILED_SET.add("PhoneNumberSet");
        IGNORE_FILED_SET.add("TemplateParamSet");
        IGNORE_FILED_SET.add("SessionContext");
        IGNORE_FILED_SET.add("SessionContextSet");
        IGNORE_FILED_SET.add("ContextParamSet");
    }
}

