/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.chuanglan.service;

import cn.hutool.json.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.chuanglan.config.ChuangLanConfig;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChuangLanSmsImpl
extends AbstractSmsBlend<ChuangLanConfig> {
    private static final Logger log = LoggerFactory.getLogger(ChuangLanSmsImpl.class);
    private int retry = 0;

    public ChuangLanSmsImpl(ChuangLanConfig config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
    }

    public ChuangLanSmsImpl(ChuangLanConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "chuanglan";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        return this.sendMessage(phone, ((ChuangLanConfig)this.getConfig()).getTemplateId(), SmsUtils.buildMessageByAmpersand((String)message));
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        return this.sendMessage(phone, ((ChuangLanConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (SmsUtils.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        String message = String.join((CharSequence)",", messages.values());
        ChuangLanConfig config = (ChuangLanConfig)this.getConfig();
        LinkedHashMap<String, Object> body = ChuangLanSmsImpl.buildBody(config.getAccessKeyId(), config.getAccessKeySecret(), templateId);
        body.put("params", phone + "," + message);
        return this.getSmsResponse(body);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        return this.massTexting(phones, ((ChuangLanConfig)this.getConfig()).getTemplateId(), SmsUtils.buildMessageByAmpersand((String)message));
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (SmsUtils.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        String message = String.join((CharSequence)",", messages.values());
        StringBuilder param = new StringBuilder();
        phones.forEach(phone -> param.append((String)phone).append(",").append(message).append(";"));
        ChuangLanConfig config = (ChuangLanConfig)this.getConfig();
        LinkedHashMap<String, Object> params = ChuangLanSmsImpl.buildBody(config.getAccessKeyId(), config.getAccessKeySecret(), templateId);
        params.put("params", param.toString());
        return this.getSmsResponse(params);
    }

    private static String buildUrl(String baseUrl, String msgUrl) {
        return baseUrl + msgUrl;
    }

    private static LinkedHashMap<String, String> buildHeaders() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(1);
        headers.put("Content-Type", "application/json");
        return headers;
    }

    private static LinkedHashMap<String, Object> buildBody(String accessKeyId, String accessKeySecret, String templateId) {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>(3);
        body.put("account", accessKeyId);
        body.put("password", accessKeySecret);
        body.put("msg", templateId);
        return body;
    }

    private SmsResponse getSmsResponse(LinkedHashMap<String, Object> body) {
        SmsResponse smsResponse;
        ChuangLanConfig config = (ChuangLanConfig)this.getConfig();
        String reqUrl = ChuangLanSmsImpl.buildUrl(config.getBaseUrl(), config.getMsgUrl());
        try {
            smsResponse = this.getResponse(this.http.postJson(reqUrl, ChuangLanSmsImpl.buildHeaders(), body));
        }
        catch (SmsBlendException e) {
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry >= ((ChuangLanConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        this.http.safeSleep(((ChuangLanConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.requestRetry(body);
    }

    private SmsResponse requestRetry(LinkedHashMap<String, Object> body) {
        this.http.safeSleep(((ChuangLanConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.getSmsResponse(body);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        return SmsRespUtils.resp((Object)resJson, (resJson.containsKey((Object)"code") && "0".equals(resJson.getStr((Object)"code")) ? 1 : 0) != 0, (String)this.getConfigId());
    }
}

