/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.yunpian.service;

import cn.hutool.json.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.dromara.sms4j.yunpian.config.YunpianConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunPianSmsImpl
extends AbstractSmsBlend<YunpianConfig> {
    private static final Logger log = LoggerFactory.getLogger(YunPianSmsImpl.class);
    private int retry = 0;

    public YunPianSmsImpl(YunpianConfig config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
    }

    public YunPianSmsImpl(YunpianConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "yunpian";
    }

    private SmsResponse getResponse(JSONObject execute) {
        SmsResponse smsResponse = new SmsResponse();
        if (execute == null) {
            smsResponse.setSuccess(false);
            return smsResponse;
        }
        smsResponse.setSuccess(execute.getInt((Object)"code") == 0);
        smsResponse.setData((Object)execute);
        smsResponse.setConfigId(this.getConfigId());
        return smsResponse;
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        Map<String, Object> body = this.setBody(phone, message, null, ((YunpianConfig)this.getConfig()).getTemplateId());
        Map<String, String> headers = this.getHeaders();
        try {
            SmsResponse smsResponse = this.getResponse(this.http.postFrom("https://sms.yunpian.com/v2/sms/tpl_single_send.json", headers, body));
            if (smsResponse.isSuccess() || this.retry == ((YunpianConfig)this.getConfig()).getMaxRetries()) {
                this.retry = 0;
                return smsResponse;
            }
            return this.requestRetry(phone, message);
        }
        catch (SmsBlendException e) {
            return this.requestRetry(phone, message);
        }
    }

    private SmsResponse requestRetry(String phone, String message) {
        this.http.safeSleep(((YunpianConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.sendMessage(phone, message);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        Map<String, Object> body = this.setBody(phone, "", messages, templateId);
        Map<String, String> headers = this.getHeaders();
        try {
            SmsResponse smsResponse = this.getResponse(this.http.postFrom("https://sms.yunpian.com/v2/sms/tpl_single_send.json", headers, body));
            if (smsResponse.isSuccess() || this.retry == ((YunpianConfig)this.getConfig()).getMaxRetries()) {
                this.retry = 0;
                return smsResponse;
            }
            return this.requestRetry(phone, templateId, messages);
        }
        catch (SmsBlendException e) {
            return this.requestRetry(phone, templateId, messages);
        }
    }

    private SmsResponse requestRetry(String phone, String templateId, LinkedHashMap<String, String> messages) {
        this.http.safeSleep(((YunpianConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.sendMessage(phone, templateId, messages);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        if (phones.size() > 1000) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e1000");
        }
        return this.sendMessage(SmsUtils.listToString(phones), message);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (phones.size() > 1000) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e1000");
        }
        return this.sendMessage(SmsUtils.listToString(phones), templateId, messages);
    }

    private String formattingMap(Map<String, String> messages) {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            str.append("#");
            str.append(entry.getKey());
            str.append("#=");
            str.append(entry.getValue());
            str.append("&");
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    private Map<String, Object> setBody(String phone, String mes, LinkedHashMap<String, String> messages, String tplId) {
        LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
        if (mes.isEmpty()) {
            message = messages;
        } else {
            message.put(((YunpianConfig)this.getConfig()).getTemplateName(), mes);
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("apikey", ((YunpianConfig)this.getConfig()).getAccessKeyId());
        body.put("mobile", phone);
        body.put("tpl_id", tplId);
        body.put("tpl_value", this.formattingMap(message));
        if (((YunpianConfig)this.getConfig()).getCallbackUrl() != null && !((YunpianConfig)this.getConfig()).getCallbackUrl().isEmpty()) {
            body.put("callback_url", ((YunpianConfig)this.getConfig()).getCallbackUrl());
        }
        return body;
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json; charset=utf-8");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return headers;
    }
}

