/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.ctyun.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.json.JSONUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.ctyun.config.CtyunConfig;

public class CtyunUtils {
    private static String signatureTime() {
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        return timeFormat.format(new Date());
    }

    public static Map<String, String> signHeader(String body, String key, String secret) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>(4);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date now = new Date();
        String signatureDate = dateFormat.format(now);
        String signatureTime = CtyunUtils.signatureTime();
        String uuid = UUID.randomUUID().toString();
        String calculateContentHash = CtyunUtils.getSHA256(body);
        byte[] kTime = CtyunUtils.hmacSHA256(signatureTime.getBytes(), secret.getBytes());
        byte[] kAk = CtyunUtils.hmacSHA256(key.getBytes(), kTime);
        byte[] kDate = CtyunUtils.hmacSHA256(signatureDate.getBytes(), kAk);
        String signatureStr = String.format("ctyun-eop-request-id:%s\neop-date:%s\n", uuid, signatureTime) + "\n\n" + calculateContentHash;
        String signature = Base64.encode((byte[])CtyunUtils.hmacSHA256(signatureStr.getBytes(StandardCharsets.UTF_8), kDate));
        String signHeader = String.format("%s Headers=ctyun-eop-request-id;eop-date Signature=%s", key, signature);
        map.put("Content-Type", "application/json; charset=utf-8");
        map.put("ctyun-eop-request-id", uuid);
        map.put("Eop-date", signatureTime);
        map.put("Eop-Authorization", signHeader);
        return map;
    }

    public static String generateParamJsonStr(CtyunConfig ctyunConfig, String phone, String message, String templateId) {
        HashMap<String, String> paramMap = new HashMap<String, String>(5);
        paramMap.put("action", ctyunConfig.getAction());
        paramMap.put("phoneNumber", phone);
        paramMap.put("signName", ctyunConfig.getSignature());
        paramMap.put("templateParam", message);
        paramMap.put("templateCode", templateId);
        return JSONUtil.toJsonStr(paramMap);
    }

    private static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte b : data) {
            String hex = Integer.toHexString(b);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    private static String getSHA256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return CtyunUtils.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException var3) {
            return null;
        }
    }

    private static byte[] hmacSHA256(byte[] data, byte[] key) {
        try {
            HMac hMac = new HMac(HmacAlgorithm.HmacSHA256, key);
            return hMac.digest(data);
        }
        catch (Exception e) {
            throw new SmsBlendException(e.getMessage());
        }
    }

    private CtyunUtils() {
    }
}

