/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.autoimmit.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    public void init(RedisConnectionFactory connectionFactory) {
        if (connectionFactory == null) {
            log.error("RedisConnectionFactory is not found");
        }
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer valueSerializer = new JdkSerializationRedisSerializer();
        StringRedisTemplate stringTemplate = new StringRedisTemplate();
        stringTemplate.setConnectionFactory(connectionFactory);
        stringTemplate.afterPropertiesSet();
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        template.setKeySerializer((RedisSerializer)keySerializer);
        template.setHashKeySerializer((RedisSerializer)keySerializer);
        template.setValueSerializer((RedisSerializer)valueSerializer);
        template.setHashValueSerializer((RedisSerializer)valueSerializer);
        template.afterPropertiesSet();
        this.redisTemplate = template;
    }

    public RedisUtils() {
    }

    public RedisUtils(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean setTimeByKey(String key, Long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time.longValue(), TimeUnit.SECONDS);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
        return true;
    }

    public boolean setOrTime(String key, Object value, Long time) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value, time.longValue(), TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean multiSet(Map valueMap) {
        try {
            this.redisTemplate.opsForValue().multiSet(valueMap);
            return true;
        }
        catch (Exception e) {
            log.error(e.toString());
            return false;
        }
    }

    public Object getByKey(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public String getKyeString(String key) {
        return (String)this.getByKey(key);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean deleteKey(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                return this.redisTemplate.delete((Object)key[0]);
            }
            Long delete = this.redisTemplate.delete(Arrays.asList(key));
            return delete >= 1L;
        }
        return false;
    }

    public Boolean delete(String key) {
        Set keys = this.redisTemplate.keys((Object)(key + "*"));
        this.redisTemplate.delete((Collection)keys);
        return true;
    }

    public Long getKeyExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public void renameKey(String oldKey, String newKey) {
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public <T, M> void MapSetMap(String key, Map<T, M> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public Set<Object> MapGetHashByKey(String key) {
        return this.redisTemplate.opsForHash().keys((Object)key);
    }

    public Object MapGetValueByFieID(String key, String fieId) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)fieId);
    }

    public Map<Object, Object> MapGetMapByKey(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public void MapSetNewMapValue(String key, String hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
    }

    public Long MapHashDelete(String key, Object ... fields) {
        return this.redisTemplate.opsForHash().delete((Object)key, fields);
    }

    public Long MapGetMapValueSize(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public Boolean listAddInHead(String key, Object value) {
        try {
            this.redisTemplate.opsForList().leftPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public Boolean listAddAllInHead(String key, Collection<?> values) {
        try {
            this.redisTemplate.opsForList().leftPushAll((Object)key, new Object[]{values});
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public Boolean listAddIfPresent(String key, Object value) {
        try {
            this.redisTemplate.opsForList().leftPushIfPresent((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public Boolean listAddInEnd(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public Boolean listAddAllInEnd(String key, Collection<?> values) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, new Object[]{values});
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public Boolean listAddByIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public Object listGetByIndex(String key, long index) {
        return this.redisTemplate.opsForList().index((Object)key, index);
    }

    public List<Object> listGetByRange(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public Object listLeftPop(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public Object listRightPop(String key) {
        return this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public Long listGetSize(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public Long listRemove(String key, long index, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, index, value);
    }

    public void empty() {
        this.redisTemplate.getConnectionFactory().getConnection().flushAll();
    }
}

