/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.img.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.ansi.Ansi4BitColor;
import org.dromara.hutool.core.lang.ansi.Ansi8BitColor;
import org.dromara.hutool.core.lang.ansi.AnsiElement;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.RandomUtil;
import org.dromara.hutool.swing.img.color.Ansi4bitMapping;
import org.dromara.hutool.swing.img.color.Ansi8bitMapping;

public class ColorUtil {
    private static final Map<String, Color> COLOR_MAPPING;
    private static final int RGB_COLOR_BOUND = 256;

    public static String toCssRgb(Color color) {
        return StrUtil.builder().append("rgb(").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append(")").toString();
    }

    public static String toCssRgba(Color color) {
        return StrUtil.builder().append("rgba(").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append(",").append((double)color.getAlpha() / 255.0).append(")").toString();
    }

    public static String toHex(Color color) {
        return ColorUtil.toHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String toHex(int r, int g, int b) {
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("RGB must be 0~255!");
        }
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public static Color getColor(String colorName) {
        if (StrUtil.isBlank((CharSequence)colorName)) {
            return null;
        }
        Color color = COLOR_MAPPING.get(colorName = colorName.toUpperCase());
        if (null != color) {
            return color;
        }
        if (StrUtil.startWith((CharSequence)colorName, (char)'#')) {
            return ColorUtil.hexToColor(colorName);
        }
        if (StrUtil.startWith((CharSequence)colorName, (char)'$')) {
            return ColorUtil.hexToColor("#" + colorName.substring(1));
        }
        List rgb = SplitUtil.split((CharSequence)colorName, (CharSequence)",");
        int size = rgb.size();
        if (3 == size) {
            Integer[] rgbIntegers = ConvertUtil.toIntArray((Object)rgb);
            return new Color(rgbIntegers[0], rgbIntegers[1], rgbIntegers[2]);
        }
        if (4 == size) {
            Float[] rgbFloats = ConvertUtil.toFloatArray((Object)rgb);
            Float a = rgbFloats[3];
            if (a.floatValue() < 1.0f) {
                a = Float.valueOf(a.floatValue() * 255.0f);
            }
            return new Color(rgbFloats[0].floatValue(), rgbFloats[1].floatValue(), rgbFloats[2].floatValue(), a.floatValue());
        }
        return null;
    }

    public static Color getColor(int rgb) {
        return new Color(rgb);
    }

    public static Color hexToColor(String hex) {
        return ColorUtil.getColor(Integer.parseInt(StrUtil.removePrefix((CharSequence)hex, (CharSequence)"#"), 16));
    }

    public static Color add(Color color1, Color color2) {
        double r1 = color1.getRed();
        double g1 = color1.getGreen();
        double b1 = color1.getBlue();
        double a1 = color1.getAlpha();
        double r2 = color2.getRed();
        double g2 = color2.getGreen();
        double b2 = color2.getBlue();
        double a2 = color2.getAlpha();
        int r = (int)((r1 * a1 / 255.0 + r2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int g = (int)((g1 * a1 / 255.0 + g2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int b = (int)((b1 * a1 / 255.0 + b2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        return new Color(r, g, b);
    }

    public static Color randomColor() {
        return ColorUtil.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomUtil.getRandom();
        }
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    public static Color randomColor(Color compareColor, int minDistance) {
        Color color = ColorUtil.randomColor();
        if (null != compareColor && minDistance > 0) {
            Assert.isTrue((minDistance < ColorUtil.maxDistance(compareColor) / 3 * 2 ? 1 : 0) != 0, (String)"minDistance is too large, there are too few remaining colors!", (Object[])new Object[0]);
            while (ColorUtil.computeColorDistance(compareColor, color) < minDistance) {
                color = ColorUtil.randomColor();
            }
        }
        return color;
    }

    public static int computeColorDistance(Color color1, Color color2) {
        if (null == color1 || null == color2) {
            return 443;
        }
        return (int)Math.sqrt(Math.pow(color1.getRed() - color2.getRed(), 2.0) + Math.pow(color1.getGreen() - color2.getGreen(), 2.0) + Math.pow(color1.getBlue() - color2.getBlue(), 2.0));
    }

    public static int maxDistance(Color color) {
        if (null == color) {
            return 443;
        }
        int maxX = 256 - 2 * color.getRed();
        int maxY = 256 - 2 * color.getGreen();
        int maxZ = 256 - 2 * color.getBlue();
        return (int)Math.sqrt(maxX * maxX + maxY * maxY + maxZ * maxZ);
    }

    public static AnsiElement toAnsiColor(int rgb, boolean is8Bit, boolean isBackground) {
        return ColorUtil.toAnsiColor(ColorUtil.getColor(rgb), is8Bit, isBackground);
    }

    public static AnsiElement toAnsiColor(Color color, boolean is8Bit, boolean isBackground) {
        if (is8Bit) {
            Ansi8BitColor ansiElement = (Ansi8BitColor)Ansi8bitMapping.INSTANCE.lookupClosest(color);
            if (isBackground) {
                return ansiElement.asBackground();
            }
            return ansiElement;
        }
        Ansi4BitColor ansiElement = (Ansi4BitColor)Ansi4bitMapping.INSTANCE.lookupClosest(color);
        if (isBackground) {
            return ansiElement.asBackground();
        }
        return ansiElement;
    }

    public static String getMainColor(BufferedImage image, int[] ... rgbFilters) {
        HashMap<String, Long> countMap = new HashMap<String, Long>();
        int width = image.getWidth();
        int height = image.getHeight();
        int minx = image.getMinX();
        int miny = image.getMinY();
        for (int i = minx; i < width; ++i) {
            for (int j = miny; j < height; ++j) {
                int b;
                int g;
                int pixel = image.getRGB(i, j);
                int r = (pixel & 0xFF0000) >> 16;
                if (ColorUtil.matchFilters(r, g = (pixel & 0xFF00) >> 8, b = pixel & 0xFF, rgbFilters)) continue;
                countMap.merge(r + "-" + g + "-" + b, 1L, Long::sum);
            }
        }
        String maxColor = null;
        long maxCount = 0L;
        for (Map.Entry entry : countMap.entrySet()) {
            String key = (String)entry.getKey();
            Long count = (Long)entry.getValue();
            if (count <= maxCount) continue;
            maxColor = key;
            maxCount = count;
        }
        String[] splitRgbStr = SplitUtil.splitToArray(maxColor, (CharSequence)"-");
        String rHex = Integer.toHexString(Integer.parseInt(splitRgbStr[0]));
        String gHex = Integer.toHexString(Integer.parseInt(splitRgbStr[1]));
        String bHex = Integer.toHexString(Integer.parseInt(splitRgbStr[2]));
        rHex = rHex.length() == 1 ? "0" + rHex : rHex;
        gHex = gHex.length() == 1 ? "0" + gHex : gHex;
        bHex = bHex.length() == 1 ? "0" + bHex : bHex;
        return "#" + rHex + gHex + bHex;
    }

    private static boolean matchFilters(int r, int g, int b, int[] ... rgbFilters) {
        if (ArrayUtil.isNotEmpty((Object[])rgbFilters)) {
            for (int[] rgbFilter : rgbFilters) {
                if (r != rgbFilter[0] || g != rgbFilter[1] || b != rgbFilter[2]) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Map colorMap = MapUtil.builder((Object)"BLACK", (Object)Color.BLACK).put((Object)"WHITE", (Object)Color.WHITE).put((Object)"LIGHTGRAY", (Object)Color.LIGHT_GRAY).put((Object)"LIGHT_GRAY", (Object)Color.LIGHT_GRAY).put((Object)"GRAY", (Object)Color.GRAY).put((Object)"DARKGRAY", (Object)Color.DARK_GRAY).put((Object)"DARK_GRAY", (Object)Color.DARK_GRAY).put((Object)"RED", (Object)Color.RED).put((Object)"PINK", (Object)Color.PINK).put((Object)"ORANGE", (Object)Color.ORANGE).put((Object)"YELLOW", (Object)Color.YELLOW).put((Object)"GREEN", (Object)Color.GREEN).put((Object)"MAGENTA", (Object)Color.MAGENTA).put((Object)"CYAN", (Object)Color.CYAN).put((Object)"BLUE", (Object)Color.BLUE).put((Object)"DARKGOLD", (Object)ColorUtil.hexToColor("#9e7e67")).put((Object)"DARK_GOLD", (Object)ColorUtil.hexToColor("#9e7e67")).put((Object)"LIGHTGOLD", (Object)ColorUtil.hexToColor("#ac9c85")).put((Object)"LIGHT_GOLD", (Object)ColorUtil.hexToColor("#ac9c85")).build();
        COLOR_MAPPING = MapUtil.view((Map)colorMap);
    }
}

