/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.codehaus.mojo.versions.api.PomHelper;

@Mojo(name="revert", threadSafe=true)
public class RevertMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="processFromLocalAggregationRoot", defaultValue="true")
    private boolean processFromLocalAggregationRoot;
    protected final ProjectBuilder projectBuilder;

    @Inject
    protected RevertMojo(ProjectBuilder projectBuilder) {
        this.projectBuilder = projectBuilder;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject projectToProcess = !this.processFromLocalAggregationRoot ? PomHelper.getLocalRoot((ProjectBuilder)this.projectBuilder, (MavenSession)this.session, (Log)this.getLog()) : this.session.getCurrentProject();
        Path projectFileName = projectToProcess.getFile().toPath().getFileName();
        this.getLog().info((CharSequence)("Local aggregation root: " + projectToProcess.getBasedir()));
        Set reactor = PomHelper.getAllChildModules((MavenProject)projectToProcess, (Log)this.getLog());
        reactor.add(".");
        reactor.forEach(entry -> {
            Path pomFile = projectToProcess.getBasedir().toPath().resolve((String)entry).resolve(projectFileName).normalize();
            this.getLog().debug((CharSequence)("Processing:" + pomFile));
            Path backupFile = Paths.get(pomFile + ".versionsBackup", new String[0]);
            if (Files.exists(backupFile, new LinkOption[0])) {
                this.getLog().info((CharSequence)("Restoring " + pomFile + " from " + backupFile));
                try {
                    Files.copy(backupFile, pomFile, StandardCopyOption.REPLACE_EXISTING);
                    try {
                        Files.delete(backupFile);
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)("Error deleting " + backupFile));
                    }
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Error copying " + backupFile + " onto " + pomFile));
                }
            }
        });
    }
}

