/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.repository.legacy.WagonConfigurationException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;

public final class WagonUtils {
    private WagonUtils() {
        throw new IllegalAccessError("Utility classes should never be instantiated");
    }

    public static ProxyInfo getProxyInfo(Settings settings) {
        ProxyInfo proxyInfo = null;
        if (settings != null && settings.getActiveProxy() != null) {
            proxyInfo = new ProxyInfo();
            Proxy proxy = settings.getActiveProxy();
            proxyInfo.setHost(proxy.getHost());
            proxyInfo.setType(proxy.getProtocol());
            proxyInfo.setPort(proxy.getPort());
            proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
            proxyInfo.setUserName(proxy.getUsername());
            proxyInfo.setPassword(proxy.getPassword());
        }
        return proxyInfo;
    }

    public static Wagon createWagon(String serverId, String url, WagonManager wagonManager, Settings settings, Log logger) throws UnsupportedProtocolException, WagonConfigurationException, ConnectionException, AuthenticationException {
        ProxyInfo proxyInfo;
        Repository repository = new Repository(serverId, url);
        Wagon wagon = wagonManager.getWagon(repository);
        if (logger.isDebugEnabled()) {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
        }
        if ((proxyInfo = WagonUtils.getProxyInfo(settings)) != null) {
            wagon.connect(repository, wagonManager.getAuthenticationInfo(repository.getId()), proxyInfo);
        } else {
            wagon.connect(repository, wagonManager.getAuthenticationInfo(repository.getId()));
        }
        return wagon;
    }
}

