/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.xc;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.StdDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlAdapterJsonDeserializer
extends StdDeserializer<Object> {
    private final XmlAdapter<Object, Object> xmlAdapter;
    private final Class<?> valueClass;

    public XmlAdapterJsonDeserializer(XmlAdapter<Object, Object> xmlAdapter) {
        super(Object.class);
        this.xmlAdapter = xmlAdapter;
        this.valueClass = this.findValueClass();
    }

    private Class<?> findValueClass() {
        Type superClass = this.xmlAdapter.getClass().getGenericSuperclass();
        while (superClass instanceof ParameterizedType && XmlAdapter.class != ((ParameterizedType)superClass).getRawType()) {
            superClass = ((Class)((ParameterizedType)superClass).getRawType()).getGenericSuperclass();
        }
        return (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object boundObject = jp.readValueAs(this.valueClass);
        try {
            return this.xmlAdapter.unmarshal(boundObject);
        }
        catch (Exception e) {
            throw new JsonMappingException("Unable to unmarshal: " + e.getMessage(), (Throwable)e);
        }
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }
}

