/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom.format;

import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.camunda.spin.impl.xml.dom.DomXmlAttribute;
import org.camunda.spin.impl.xml.dom.DomXmlElement;
import org.camunda.spin.impl.xml.dom.DomXmlLogger;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormatMapper;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormatReader;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormatWriter;
import org.camunda.spin.impl.xml.dom.format.spi.DefaultJaxBContextProvider;
import org.camunda.spin.impl.xml.dom.format.spi.JaxBContextProvider;
import org.camunda.spin.spi.DataFormat;
import org.camunda.spin.xml.SpinXmlAttribute;
import org.camunda.spin.xml.SpinXmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class DomXmlDataFormat
implements DataFormat<SpinXmlElement> {
    protected static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String JAXP_ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
    protected static final String JAXP_ACCESS_EXTERNAL_SCHEMA_SYSTEM_PROPERTY = "javax.xml.accessExternalSchema";
    protected static final String JAXP_ACCESS_EXTERNAL_SCHEMA_ALL = "all";
    public static final String XXE_PROPERTY = "xxe-processing";
    public static final String SP_PROPERTY = "secure-processing";
    protected DocumentBuilderFactory documentBuilderFactory;
    protected TransformerFactory transformerFactory;
    protected JaxBContextProvider jaxBContextProvider;
    protected DomXmlDataFormatReader reader;
    protected DomXmlDataFormatWriter writer;
    protected DomXmlDataFormatMapper mapper;
    protected final String name;
    protected boolean prettyPrint;

    public DomXmlDataFormat(String name) {
        this(name, DomXmlDataFormat.defaultDocumentBuilderFactory());
    }

    public DomXmlDataFormat(String name, Map<String, Object> configurationProperties) {
        this(name, DomXmlDataFormat.configurableDocumentBuilderFactory(configurationProperties));
    }

    public DomXmlDataFormat(String name, JaxBContextProvider contextProvider) {
        this(name, DomXmlDataFormat.defaultDocumentBuilderFactory(), contextProvider);
    }

    public DomXmlDataFormat(String name, DocumentBuilderFactory documentBuilderFactory, JaxBContextProvider contextProvider) {
        this(name, documentBuilderFactory, DomXmlDataFormat.defaultTransformerFactory(), contextProvider);
    }

    public DomXmlDataFormat(String name, DocumentBuilderFactory documentBuilderFactory) {
        this(name, documentBuilderFactory, DomXmlDataFormat.defaultTransformerFactory(), DomXmlDataFormat.defaultJaxBContextProvider());
    }

    public DomXmlDataFormat(String name, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory, JaxBContextProvider contextProvider) {
        this.name = name;
        this.documentBuilderFactory = documentBuilderFactory;
        this.prettyPrint = true;
        LOG.usingDocumentBuilderFactory(documentBuilderFactory.getClass().getName());
        this.transformerFactory = transformerFactory;
        this.jaxBContextProvider = contextProvider;
        this.init();
    }

    protected void init() {
        this.reader = new DomXmlDataFormatReader(this);
        this.writer = new DomXmlDataFormatWriter(this);
        this.mapper = new DomXmlDataFormatMapper(this);
    }

    public Class<? extends SpinXmlElement> getWrapperType() {
        return DomXmlElement.class;
    }

    public SpinXmlElement createWrapperInstance(Object parameter) {
        return this.createElementWrapper((Element)parameter);
    }

    public String getName() {
        return this.name;
    }

    public SpinXmlElement createElementWrapper(Element element) {
        return new DomXmlElement(element, this);
    }

    public SpinXmlAttribute createAttributeWrapper(Attr attr) {
        return new DomXmlAttribute(attr, this);
    }

    public DomXmlDataFormatReader getReader() {
        return this.reader;
    }

    public DomXmlDataFormatWriter getWriter() {
        return this.writer;
    }

    public DomXmlDataFormatMapper getMapper() {
        return this.mapper;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public JaxBContextProvider getJaxBContextProvider() {
        return this.jaxBContextProvider;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
        this.writer.reloadFormattingTemplates();
    }

    public void setJaxBContextProvider(JaxBContextProvider jaxBContextProvider) {
        this.jaxBContextProvider = jaxBContextProvider;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public static TransformerFactory defaultTransformerFactory() {
        return TransformerFactory.newInstance();
    }

    public static DocumentBuilderFactory defaultDocumentBuilderFactory() {
        return DomXmlDataFormat.configurableDocumentBuilderFactory(Collections.emptyMap());
    }

    public static DocumentBuilderFactory configurableDocumentBuilderFactory(Map<String, Object> configurationProperties) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        LOG.documentBuilderFactoryConfiguration("namespaceAware", "true");
        documentBuilderFactory.setValidating(false);
        LOG.documentBuilderFactoryConfiguration("validating", "false");
        documentBuilderFactory.setIgnoringComments(true);
        LOG.documentBuilderFactoryConfiguration("ignoringComments", "true");
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        LOG.documentBuilderFactoryConfiguration("ignoringElementContentWhitespace", "false");
        if (!((Boolean)configurationProperties.getOrDefault(XXE_PROPERTY, false)).booleanValue()) {
            DomXmlDataFormat.disableXxeProcessing(documentBuilderFactory);
        }
        if (((Boolean)configurationProperties.getOrDefault(SP_PROPERTY, true)).booleanValue()) {
            DomXmlDataFormat.enableSecureProcessing(documentBuilderFactory);
        }
        return documentBuilderFactory;
    }

    public static JaxBContextProvider defaultJaxBContextProvider() {
        return new DefaultJaxBContextProvider();
    }

    protected static void disableXxeProcessing(DocumentBuilderFactory dbf) {
        try {
            dbf.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            dbf.setFeature(DISALLOW_DOCTYPE_DECL, true);
            dbf.setFeature(LOAD_EXTERNAL_DTD, false);
            dbf.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
    }

    protected static void enableSecureProcessing(DocumentBuilderFactory dbf) {
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setAttribute(JAXP_ACCESS_EXTERNAL_SCHEMA, DomXmlDataFormat.resolveAccessExternalSchemaProperty());
        }
        catch (IllegalArgumentException | ParserConfigurationException exception) {
            // empty catch block
        }
    }

    protected static String resolveAccessExternalSchemaProperty() {
        String systemProperty = System.getProperty(JAXP_ACCESS_EXTERNAL_SCHEMA_SYSTEM_PROPERTY);
        if (systemProperty != null) {
            return systemProperty;
        }
        return JAXP_ACCESS_EXTERNAL_SCHEMA_ALL;
    }
}

