/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath.internal.path;

import java.util.Collection;
import spinjar.com.jayway.jsonpath.Option;
import spinjar.com.jayway.jsonpath.internal.PathRef;
import spinjar.com.jayway.jsonpath.internal.path.ArrayPathToken;
import spinjar.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import spinjar.com.jayway.jsonpath.internal.path.PathToken;
import spinjar.com.jayway.jsonpath.internal.path.PredicatePathToken;
import spinjar.com.jayway.jsonpath.internal.path.PropertyPathToken;
import spinjar.com.jayway.jsonpath.internal.path.WildcardPathToken;
import spinjar.com.jayway.jsonpath.spi.json.JsonProvider;

public class ScanPathToken
extends PathToken {
    private static final Predicate FALSE_PREDICATE = new Predicate(){

        @Override
        public boolean matches(Object model) {
            return false;
        }
    };

    ScanPathToken() {
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        PathToken pt = this.next();
        ScanPathToken.walk(pt, currentPath, parent, model, ctx, ScanPathToken.createScanPredicate(pt, ctx));
    }

    public static void walk(PathToken pt, String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx, Predicate predicate) {
        if (ctx.jsonProvider().isMap(model)) {
            ScanPathToken.walkObject(pt, currentPath, parent, model, ctx, predicate);
        } else if (ctx.jsonProvider().isArray(model)) {
            ScanPathToken.walkArray(pt, currentPath, parent, model, ctx, predicate);
        }
    }

    public static void walkArray(PathToken pt, String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx, Predicate predicate) {
        if (predicate.matches(model)) {
            if (pt.isLeaf()) {
                pt.evaluate(currentPath, parent, model, ctx);
            } else {
                PathToken next = pt.next();
                Iterable<?> models = ctx.jsonProvider().toIterable(model);
                int idx = 0;
                for (Object evalModel : models) {
                    String evalPath = currentPath + "[" + idx + "]";
                    next.evaluate(evalPath, parent, evalModel, ctx);
                    ++idx;
                }
            }
        }
        Iterable<?> models = ctx.jsonProvider().toIterable(model);
        int idx = 0;
        for (Object evalModel : models) {
            String evalPath = currentPath + "[" + idx + "]";
            ScanPathToken.walk(pt, evalPath, PathRef.create(model, idx), evalModel, ctx, predicate);
            ++idx;
        }
    }

    public static void walkObject(PathToken pt, String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx, Predicate predicate) {
        if (predicate.matches(model)) {
            pt.evaluate(currentPath, parent, model, ctx);
        }
        Collection<String> properties = ctx.jsonProvider().getPropertyKeys(model);
        for (String property : properties) {
            String evalPath = currentPath + "['" + property + "']";
            Object propertyModel = ctx.jsonProvider().getMapValue(model, property);
            if (propertyModel == JsonProvider.UNDEFINED) continue;
            ScanPathToken.walk(pt, evalPath, PathRef.create(model, property), propertyModel, ctx, predicate);
        }
    }

    private static Predicate createScanPredicate(PathToken target, EvaluationContextImpl ctx) {
        if (target instanceof PropertyPathToken) {
            return new PropertyPathTokenPredicate(target, ctx);
        }
        if (target instanceof ArrayPathToken) {
            return new ArrayPathTokenPredicate(ctx);
        }
        if (target instanceof WildcardPathToken) {
            return new WildcardPathTokenPredicate();
        }
        if (target instanceof PredicatePathToken) {
            return new FilterPathTokenPredicate(target, ctx);
        }
        return FALSE_PREDICATE;
    }

    @Override
    public boolean isTokenDefinite() {
        return false;
    }

    @Override
    public String getPathFragment() {
        return "..";
    }

    private static final class PropertyPathTokenPredicate
    implements Predicate {
        private final EvaluationContextImpl ctx;
        private PropertyPathToken propertyPathToken;

        private PropertyPathTokenPredicate(PathToken target, EvaluationContextImpl ctx) {
            this.ctx = ctx;
            this.propertyPathToken = (PropertyPathToken)target;
        }

        @Override
        public boolean matches(Object model) {
            if (!this.ctx.jsonProvider().isMap(model)) {
                return false;
            }
            if (!this.propertyPathToken.isTokenDefinite()) {
                return true;
            }
            if (this.propertyPathToken.isLeaf() && this.ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
                return true;
            }
            Collection<String> keys = this.ctx.jsonProvider().getPropertyKeys(model);
            return keys.containsAll(this.propertyPathToken.getProperties());
        }
    }

    private static final class ArrayPathTokenPredicate
    implements Predicate {
        private final EvaluationContextImpl ctx;

        private ArrayPathTokenPredicate(EvaluationContextImpl ctx) {
            this.ctx = ctx;
        }

        @Override
        public boolean matches(Object model) {
            return this.ctx.jsonProvider().isArray(model);
        }
    }

    private static final class WildcardPathTokenPredicate
    implements Predicate {
        private WildcardPathTokenPredicate() {
        }

        @Override
        public boolean matches(Object model) {
            return true;
        }
    }

    private static final class FilterPathTokenPredicate
    implements Predicate {
        private final EvaluationContextImpl ctx;
        private PredicatePathToken predicatePathToken;

        private FilterPathTokenPredicate(PathToken target, EvaluationContextImpl ctx) {
            this.ctx = ctx;
            this.predicatePathToken = (PredicatePathToken)target;
        }

        @Override
        public boolean matches(Object model) {
            return this.predicatePathToken.accept(model, this.ctx.rootDocument(), this.ctx.configuration(), this.ctx);
        }
    }

    private static interface Predicate {
        public boolean matches(Object var1);
    }
}

