/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instruction;

import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class SameEventScopeInstructionValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        if (this.isCompensationBoundaryEvent(sourceActivity)) {
            return;
        }
        ScopeImpl sourceEventScope = instruction.getSourceActivity().getEventScope();
        ScopeImpl targetEventScope = instruction.getTargetActivity().getEventScope();
        if (sourceEventScope == null || sourceEventScope == sourceActivity.getFlowScope()) {
            return;
        }
        if (targetEventScope == null) {
            report.addFailure("The source activity's event scope (" + sourceEventScope.getId() + ") must be mapped but the " + "target activity has no event scope");
        } else {
            ScopeImpl mappedSourceEventScope = this.findMappedEventScope(sourceEventScope, instruction, instructions);
            if (mappedSourceEventScope == null || !mappedSourceEventScope.getId().equals(targetEventScope.getId())) {
                report.addFailure("The source activity's event scope (" + sourceEventScope.getId() + ") " + "must be mapped to the target activity's event scope (" + targetEventScope.getId() + ")");
            }
        }
    }

    protected boolean isCompensationBoundaryEvent(ActivityImpl sourceActivity) {
        String activityType = sourceActivity.getProperties().get(BpmnProperties.TYPE);
        return "compensationBoundaryCatch".equals(activityType);
    }

    protected ScopeImpl findMappedEventScope(ScopeImpl sourceEventScope, ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions) {
        if (sourceEventScope != null) {
            if (sourceEventScope == sourceEventScope.getProcessDefinition()) {
                return instruction.getTargetActivity().getProcessDefinition();
            }
            List<ValidatingMigrationInstruction> eventScopeInstructions = instructions.getInstructionsBySourceScope(sourceEventScope);
            if (eventScopeInstructions.size() > 0) {
                return eventScopeInstructions.get(0).getTargetActivity();
            }
        }
        return null;
    }

    protected void addFailure(ValidatingMigrationInstruction instruction, MigrationInstructionValidationReportImpl report, String sourceScopeId, String targetScopeId) {
        report.addFailure("The source activity's event scope (" + sourceScopeId + ") " + "must be mapped to the target activity's event scope (" + targetScopeId + ")");
    }
}

