/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.migration.instance.EmergingJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTimerJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.migration.MigrationInstruction;

public class ActivityInstanceJobHandler
implements MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, MigratingActivityInstance activityInstance, List<JobEntity> elements) {
        Map<String, TimerDeclarationImpl> timerDeclarationsInEventScope = this.getTimerDeclarationsByTriggeringActivity(activityInstance.getTargetScope());
        for (JobEntity job : elements) {
            if (!ActivityInstanceJobHandler.isTimerJob(job)) continue;
            MigrationInstruction migrationInstruction = parseContext.findSingleMigrationInstruction(job.getActivityId());
            ActivityImpl targetActivity = parseContext.getTargetActivity(migrationInstruction);
            if (targetActivity != null && activityInstance.migratesTo(targetActivity.getEventScope())) {
                JobDefinitionEntity targetJobDefinitionEntity = parseContext.getTargetJobDefinition(targetActivity.getActivityId(), job.getJobHandlerType());
                TimerDeclarationImpl targetTimerDeclaration = timerDeclarationsInEventScope.remove(targetActivity.getId());
                MigratingTimerJobInstance migratingTimerJobInstance = new MigratingTimerJobInstance(job, targetJobDefinitionEntity, targetActivity, migrationInstruction.isUpdateEventTrigger(), targetTimerDeclaration);
                activityInstance.addMigratingDependentInstance(migratingTimerJobInstance);
                parseContext.submit(migratingTimerJobInstance);
            } else {
                MigratingTimerJobInstance removingJobInstance = new MigratingTimerJobInstance(job);
                activityInstance.addRemovingDependentInstance(removingJobInstance);
                parseContext.submit(removingJobInstance);
            }
            parseContext.consume(job);
        }
        if (activityInstance.migrates()) {
            this.addEmergingTimerJobs(activityInstance, timerDeclarationsInEventScope.values());
        }
    }

    protected static boolean isTimerJob(JobEntity job) {
        return job != null && job.getType().equals("timer");
    }

    protected void addEmergingTimerJobs(MigratingActivityInstance owningInstance, Collection<TimerDeclarationImpl> emergingDeclarations) {
        for (TimerDeclarationImpl timerDeclaration : emergingDeclarations) {
            owningInstance.addEmergingDependentInstance(new EmergingJobInstance(timerDeclaration));
        }
    }

    protected Map<String, TimerDeclarationImpl> getTimerDeclarationsByTriggeringActivity(ScopeImpl scope) {
        return new HashMap<String, TimerDeclarationImpl>(TimerDeclarationImpl.getDeclarationsForScope(scope));
    }
}

