/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.batch;

import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.json.MigrationBatchConfigurationJsonConverter;
import org.camunda.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchJobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;
import org.camunda.bpm.engine.impl.util.json.JSONTokener;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanExecutionBuilder;

public class MigrationBatchJobHandler
implements BatchJobHandler<MigrationBatchConfiguration> {
    public static final MigrationBatchJobDeclaration JOB_DECLARATION = new MigrationBatchJobDeclaration();

    @Override
    public String getType() {
        return "instance-migration";
    }

    @Override
    public JobDeclaration<?, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    public byte[] writeConfiguration(MigrationBatchConfiguration configuration) {
        JSONObject jsonObject = MigrationBatchConfigurationJsonConverter.INSTANCE.toJsonObject(configuration);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Writer writer = StringUtil.writerForStream(outStream);
        jsonObject.write(writer);
        IoUtil.flushSilently(writer);
        return outStream.toByteArray();
    }

    @Override
    public MigrationBatchConfiguration readConfiguration(byte[] serializedConfiguration) {
        Reader jsonReader = StringUtil.readerFromBytes(serializedConfiguration);
        return MigrationBatchConfigurationJsonConverter.INSTANCE.toObject(new JSONObject(new JSONTokener(jsonReader)));
    }

    @Override
    public boolean createJobs(BatchEntity batch) {
        CommandContext commandContext = Context.getCommandContext();
        ByteArrayManager byteArrayManager = commandContext.getByteArrayManager();
        JobManager jobManager = commandContext.getJobManager();
        MigrationBatchConfiguration configuration = this.readConfiguration(batch.getConfigurationBytes());
        MigrationPlan migrationPlan = configuration.getMigrationPlan();
        String sourceDeploymentId = this.getProcessDefinition(commandContext, migrationPlan.getSourceProcessDefinitionId()).getDeploymentId();
        int batchJobsPerSeed = batch.getBatchJobsPerSeed();
        int invocationsPerBatchJob = batch.getInvocationsPerBatchJob();
        List<String> processInstanceIds = configuration.getProcessInstanceIds();
        int numberOfInstancesToProcess = Math.min(invocationsPerBatchJob * batchJobsPerSeed, processInstanceIds.size());
        List<String> processInstancesToProcess = processInstanceIds.subList(0, numberOfInstancesToProcess);
        int createdJobs = 0;
        while (!processInstancesToProcess.isEmpty()) {
            int lastIdIndex = Math.min(invocationsPerBatchJob, processInstancesToProcess.size());
            List<String> idsForJob = processInstancesToProcess.subList(0, lastIdIndex);
            MigrationBatchConfiguration jobConfiguration = MigrationBatchConfiguration.create(migrationPlan, idsForJob, configuration.isSkipCustomListeners(), configuration.isSkipIoMappings());
            ByteArrayEntity configurationEntity = this.saveConfiguration(byteArrayManager, jobConfiguration);
            JobEntity job = this.createBatchJob(batch, configurationEntity);
            job.setDeploymentId(sourceDeploymentId);
            jobManager.insertAndHintJobExecutor(job);
            idsForJob.clear();
            ++createdJobs;
        }
        batch.setJobsCreated(batch.getJobsCreated() + createdJobs);
        batch.setConfigurationBytes(this.writeConfiguration(configuration));
        return processInstanceIds.isEmpty();
    }

    protected ByteArrayEntity saveConfiguration(ByteArrayManager byteArrayManager, MigrationBatchConfiguration jobConfiguration) {
        ByteArrayEntity configurationEntity = new ByteArrayEntity();
        configurationEntity.setBytes(this.writeConfiguration(jobConfiguration));
        byteArrayManager.insert(configurationEntity);
        return configurationEntity;
    }

    protected JobEntity createBatchJob(BatchEntity batch, ByteArrayEntity configuration) {
        MigrationBatchJobDeclaration.BatchJobContext creationContext = new MigrationBatchJobDeclaration.BatchJobContext(batch, configuration);
        return JOB_DECLARATION.createJobInstance(creationContext);
    }

    @Override
    public void deleteJobs(BatchEntity batch) {
        List<JobEntity> jobs = Context.getCommandContext().getJobManager().findJobsByJobDefinitionId(batch.getBatchJobDefinitionId());
        for (JobEntity job : jobs) {
            job.delete();
        }
    }

    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ByteArrayEntity configurationEntity = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, configuration.getConfigurationByteArrayId());
        MigrationBatchConfiguration batchConfiguration = this.readConfiguration(configurationEntity.getBytes());
        MigrationPlanExecutionBuilder executionBuilder = commandContext.getProcessEngineConfiguration().getRuntimeService().newMigration(batchConfiguration.getMigrationPlan()).processInstanceIds(batchConfiguration.getProcessInstanceIds());
        if (batchConfiguration.isSkipCustomListeners()) {
            executionBuilder.skipCustomListeners();
        }
        if (batchConfiguration.isSkipIoMappings()) {
            executionBuilder.skipIoMappings();
        }
        ((MigrationPlanExecutionBuilderImpl)executionBuilder).execute(false);
        commandContext.getByteArrayManager().delete(configurationEntity);
    }

    @Override
    public BatchJobConfiguration newConfiguration(String canonicalString) {
        return new BatchJobConfiguration(canonicalString);
    }

    @Override
    public void onDelete(BatchJobConfiguration configuration, JobEntity jobEntity) {
        String byteArrayId = configuration.getConfigurationByteArrayId();
        if (byteArrayId != null) {
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(byteArrayId);
        }
    }

    protected ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }
}

