/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;

public class TransitionInstantiationCmd
extends AbstractInstantiationCmd {
    protected String transitionId;

    public TransitionInstantiationCmd(String processInstanceId, String transitionId) {
        this(processInstanceId, transitionId, null);
    }

    public TransitionInstantiationCmd(String processInstanceId, String transitionId, String ancestorActivityInstanceId) {
        super(processInstanceId, ancestorActivityInstanceId);
        this.transitionId = transitionId;
    }

    @Override
    protected ScopeImpl getTargetFlowScope(ProcessDefinitionImpl processDefinition) {
        TransitionImpl transition = processDefinition.findTransition(this.transitionId);
        return transition.getSource().getFlowScope();
    }

    @Override
    protected CoreModelElement getTargetElement(ProcessDefinitionImpl processDefinition) {
        TransitionImpl transition = processDefinition.findTransition(this.transitionId);
        return transition;
    }

    @Override
    protected String getTargetElementId() {
        return this.transitionId;
    }

    @Override
    protected String describe() {
        StringBuilder sb = new StringBuilder();
        sb.append("Start transition '");
        sb.append(this.transitionId);
        sb.append("'");
        if (this.ancestorActivityInstanceId != null) {
            sb.append(" with ancestor activity instance '");
            sb.append(this.ancestorActivityInstanceId);
            sb.append("'");
        }
        return sb.toString();
    }
}

