/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.task.Task;

public class SaveTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String operation;
        EnsureUtil.ensureNotNull("task", (Object)this.task);
        if (this.task.getRevision() == 0) {
            try {
                this.checkCreateTask(this.task, commandContext);
                this.task.insert(null);
                commandContext.getHistoricTaskInstanceManager().createHistoricTask(this.task);
                operation = "Create";
                this.task.executeMetrics("activity-instance-start");
            }
            catch (NullValueException e) {
                throw new NotValidException(e.getMessage(), e);
            }
        } else {
            this.checkTaskAssign(this.task, commandContext);
            this.task.update();
            operation = "Update";
        }
        this.task.fireAuthorizationProvider();
        this.task.createHistoricTaskDetails(operation);
        return null;
    }

    protected void checkTaskAssign(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskAssign(task);
        }
    }

    protected void checkCreateTask(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateTask(task);
        }
    }
}

