/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.cmd.HandleExternalTaskCmd;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HandleExternalTaskFailureCmd
extends HandleExternalTaskCmd {
    protected String errorMessage;
    protected long retryDuration;
    protected int retries;

    public HandleExternalTaskFailureCmd(String externalTaskId, String workerId, String errorMessage, int retries, long retryDuration) {
        super(externalTaskId, workerId);
        this.errorMessage = errorMessage;
        this.retries = retries;
        this.retryDuration = retryDuration;
    }

    @Override
    public void execute(ExternalTaskEntity externalTask) {
        externalTask.failed(this.errorMessage, this.retries, this.retryDuration);
    }

    @Override
    protected void validateInput() {
        super.validateInput();
        EnsureUtil.ensureGreaterThanOrEqual("retries", this.retries, 0L);
        EnsureUtil.ensureGreaterThanOrEqual("retryDuration", this.retryDuration, 0L);
    }

    @Override
    public String getErrorMessageOnWrongWorkerAccess() {
        return "Failure of External Task " + this.externalTaskId + " cannot be reported by worker '" + this.workerId;
    }
}

