/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.engine.ScriptEvaluationException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;

public class SourceExecutableScript
extends ExecutableScript {
    private static final Logger LOG = Logger.getLogger(SourceExecutableScript.class.getName());
    protected String scriptSource;
    protected boolean shouldBeCompiled = true;
    protected CompiledScript compiledScript;

    public SourceExecutableScript(String language, String source) {
        super(language);
        this.scriptSource = source;
    }

    @Override
    public Object execute(ScriptEngine engine, VariableScope variableScope, Bindings bindings) {
        if (this.shouldBeCompiled) {
            this.compileScript();
        }
        return this.evaluateScript(engine, bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileScript() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (!processEngineConfiguration.isEnableScriptCompilation()) {
            this.shouldBeCompiled = false;
        } else if (this.compiledScript == null && this.shouldBeCompiled) {
            SourceExecutableScript sourceExecutableScript = this;
            synchronized (sourceExecutableScript) {
                if (this.compiledScript == null && this.shouldBeCompiled) {
                    this.compiledScript = processEngineConfiguration.getScriptingEngines().compile(this.language, this.scriptSource);
                    this.shouldBeCompiled = false;
                }
            }
        }
    }

    protected Object evaluateScript(ScriptEngine engine, Bindings bindings) {
        try {
            if (this.compiledScript != null) {
                LOG.fine("Evaluating compiled script using " + this.language + " script engine ");
                return this.compiledScript.eval(bindings);
            }
            LOG.fine("Evaluating un-compiled script using " + this.language + " script engine ");
            return engine.eval(this.scriptSource, bindings);
        }
        catch (ScriptException e) {
            throw new ScriptEvaluationException("Unable to evaluate script: " + e.getMessage(), e);
        }
    }

    public String getScriptSource() {
        return this.scriptSource;
    }

    public void setScriptSource(String scriptSource) {
        this.compiledScript = null;
        this.shouldBeCompiled = true;
        this.scriptSource = scriptSource;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public boolean isShouldBeCompiled() {
        return this.shouldBeCompiled;
    }
}

