/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.repository;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class DeploymentBuilderImpl
implements DeploymentBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient RepositoryServiceImpl repositoryService;
    protected DeploymentEntity deployment = new DeploymentEntity();
    protected boolean isDuplicateFilterEnabled = false;
    protected boolean deployChangedOnly = false;
    protected Date processDefinitionsActivationDate;

    public DeploymentBuilderImpl(RepositoryServiceImpl repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public DeploymentBuilder addInputStream(String resourceName, InputStream inputStream) {
        EnsureUtil.ensureNotNull("inputStream for resource '" + resourceName + "' is null", "inputStream", (Object)inputStream);
        byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
        ResourceEntity resource = new ResourceEntity();
        resource.setName(resourceName);
        resource.setBytes(bytes);
        this.deployment.addResource(resource);
        return this;
    }

    @Override
    public DeploymentBuilder addClasspathResource(String resource) {
        InputStream inputStream = ReflectUtil.getResourceAsStream(resource);
        EnsureUtil.ensureNotNull("resource '" + resource + "' not found", "inputStream", (Object)inputStream);
        return this.addInputStream(resource, inputStream);
    }

    @Override
    public DeploymentBuilder addString(String resourceName, String text) {
        EnsureUtil.ensureNotNull("text", (Object)text);
        ResourceEntity resource = new ResourceEntity();
        resource.setName(resourceName);
        resource.setBytes(text.getBytes());
        this.deployment.addResource(resource);
        return this;
    }

    @Override
    public DeploymentBuilder addModelInstance(String resourceName, BpmnModelInstance modelInstance) {
        EnsureUtil.ensureNotNull("modelInstance", (Object)modelInstance);
        String processText = Bpmn.convertToString((BpmnModelInstance)modelInstance);
        return this.addString(resourceName, processText);
    }

    @Override
    public DeploymentBuilder addZipInputStream(ZipInputStream zipInputStream) {
        try {
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String entryName = entry.getName();
                    byte[] bytes = IoUtil.readInputStream(zipInputStream, entryName);
                    ResourceEntity resource = new ResourceEntity();
                    resource.setName(entryName);
                    resource.setBytes(bytes);
                    this.deployment.addResource(resource);
                }
                entry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new ProcessEngineException("problem reading zip input stream", e);
        }
        return this;
    }

    @Override
    public DeploymentBuilder name(String name) {
        this.deployment.setName(name);
        return this;
    }

    @Override
    public DeploymentBuilder enableDuplicateFiltering() {
        return this.enableDuplicateFiltering(false);
    }

    @Override
    public DeploymentBuilder enableDuplicateFiltering(boolean deployChangedOnly) {
        this.isDuplicateFilterEnabled = true;
        this.deployChangedOnly = deployChangedOnly;
        return this;
    }

    @Override
    public DeploymentBuilder activateProcessDefinitionsOn(Date date) {
        this.processDefinitionsActivationDate = date;
        return this;
    }

    @Override
    public Deployment deploy() {
        return this.repositoryService.deploy(this);
    }

    @Override
    public Collection<String> getResourceNames() {
        if (this.deployment.getResources() == null) {
            return Collections.emptySet();
        }
        return this.deployment.getResources().keySet();
    }

    public DeploymentEntity getDeployment() {
        return this.deployment;
    }

    public boolean isDuplicateFilterEnabled() {
        return this.isDuplicateFilterEnabled;
    }

    public boolean isDeployChangedOnly() {
        return this.deployChangedOnly;
    }

    public Date getProcessDefinitionsActivationDate() {
        return this.processDefinitionsActivationDate;
    }
}

