/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.List;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperationActivityInstanceStart;

public class PvmAtomicOperationProcessStartInitial
extends PvmAtomicOperationActivityInstanceStart {
    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        return execution.getActivity();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        super.eventNotificationsCompleted(execution);
        ActivityImpl activity = execution.getActivity();
        ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
        ProcessInstanceStartContext processInstanceStartContext = execution.getProcessInstanceStartContext();
        if (processInstanceStartContext == null) {
            PvmExecutionImpl executionToUse = execution;
            while (processInstanceStartContext == null) {
                executionToUse = execution.getParent();
                processInstanceStartContext = executionToUse.getProcessInstanceStartContext();
            }
        }
        if (activity == processInstanceStartContext.getInitial()) {
            processInstanceStartContext.initialStarted(execution);
            execution.disposeProcessInstanceStartContext();
            execution.performOperation(ACTIVITY_EXECUTE);
        } else {
            List<ActivityImpl> initialActivityStack = processDefinition.getInitialActivityStack(processInstanceStartContext.getInitial());
            int index = initialActivityStack.indexOf(activity);
            activity = initialActivityStack.get(index + 1);
            PvmExecutionImpl executionToUse = execution;
            if (executionToUse.getActivity().isScope()) {
                executionToUse.setActive(false);
                executionToUse = executionToUse.getExecutions().get(0);
            }
            executionToUse.setActivity(activity);
            executionToUse.performOperation(PROCESS_START_INITIAL);
        }
    }

    @Override
    public String getCanonicalName() {
        return "process-start-initial";
    }
}

