/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.StartProcessInstanceCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class TimerStartEventJobHandler
implements JobHandler {
    private static Logger log = Logger.getLogger(TimerStartEventJobHandler.class.getName());
    public static final String TYPE = "timer-start-event";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext) {
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(configuration);
        try {
            if (!processDefinition.isSuspended()) {
                new StartProcessInstanceCmd(configuration, null, null, null, null).execute(commandContext);
            } else {
                log.log(Level.FINE, "ignoring timer of suspended process definition " + processDefinition.getName());
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "exception during timer execution", e);
            throw e;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "exception during timer execution", e);
            throw new ProcessEngineException("exception during timer execution: " + e.getMessage(), e);
        }
    }
}

